(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    292058,       9251]
NotebookOptionsPosition[    280405,       8920]
NotebookOutlinePosition[    281157,       8947]
CellTagsIndexPosition[    281114,       8944]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Aplicaciones de las integrales simples", "Title"],

Cell["\<\

Universidad de Granada
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
\
\>", "Text",
 PageBreakBelow->False,
 TextAlignment->Left,
 LineSpacing->{0.4, 0},
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
 "Para que todo lo que sigue funcione bien debes usar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versi\[OAcute]n 6 o posterior.\nCon una integral puedes calcular \
magnitudes tan diversas como \[AAcute]reas, vol\[UAcute]menes, longitudes de \
curvas, el trabajo realizado por una fuerza, el punto de equilibrio y la masa \
de un s\[OAcute]lido, momentos de inercia, el campo electrost\[AAcute]tico \
producido por una distribuci\[OAcute]n de cargas, el flujo de una fluido a \
trav\[EAcute]s de una superficie y muchas m\[AAcute]s."
}], "Text",
 CellChangeTimes->{{3.40691482325*^9, 3.40691487721875*^9}}],

Cell["\<\
Lo que debes aprender en este cuaderno.
Calcular \[AAcute]reas de recintos en el plano limitados por varias curvas.
Calcular \[AAcute]reas de curvas cerradas dadas por sus ecuaciones param\
\[EAcute]tricas.
Calcular longitudes de curvas.
Calcular vol\[UAcute]menes de cuerpos de revoluci\[OAcute]n por el \
m\[EAcute]todo de los discos, de las arandelas y de los tubos.
Calcular \[AAcute]reas de superficies de revoluci\[OAcute]n.\
\>", "Text"],

Cell["\<\
Para trabajar en este cuaderno debes evaluar primero (Evaluation\[RightArrow] \
Evaluate Initialization Cells) las celdas de inicializaci\[OAcute]n que \
siguen.  \
\>", "Text",
 CellChangeTimes->{{3.40691277765625*^9, 3.40691279071875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tipo1", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"var_", ",", "xmin_", ",", "xmax_"}], "}"}], ",", "opts___"}], 
   "]"}], ":=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"func1", ",", "func2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"var", ",", "xmin", ",", "xmax"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}], ",", 
      "opts"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xmin", ",", 
            RowBox[{"func1", "/.", 
             RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"xmin", ",", 
            RowBox[{"func2", "/.", 
             RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}]}], "}"}], "]"}], 
       ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xmax", ",", 
            RowBox[{"func1", "/.", 
             RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"xmax", ",", 
            RowBox[{"func2", "/.", 
             RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}]}], "}"}], "]"}]}], 
      "}"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.406907244390625*^9, 3.406907257234375*^9}, {
   3.406908047984375*^9, 3.40690807025*^9}, {3.406911185265625*^9, 
   3.406911199375*^9}, 3.4069113734375*^9, {3.406911470171875*^9, 
   3.406911486703125*^9}, {3.4069116235*^9, 3.406911627765625*^9}, {
   3.406911740078125*^9, 3.406911742140625*^9}, 3.406911794203125*^9, 
   3.4069119171875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tipo1sup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "xmin_", ",", "xmax_", ",", "sub_"}], "}"}], ",", 
     "opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rects", ",", "n", ",", "graf", ",", "inc", ",", "cotas", ",", 
       RowBox[{"area", "=", "0"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"inc", "=", 
       RowBox[{"N", "[", 
        FractionBox[
         RowBox[{"xmax", "-", "xmin"}], "sub"], "]"}]}], ";", 
      RowBox[{"rects", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"area", "=", 
               RowBox[{"area", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], "-", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], ")"}], " ", 
                 "inc"}]}]}], ";", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
                RowBox[{"Rectangle", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"n", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}]}], "}"}], "]"}],
                 ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func1", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func2", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], "]"}]}], 
               "}"}]}], ")"}], "&"}], ")"}], "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Min", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "xmin", ",", 
           RowBox[{"xmax", "-", "inc"}], ",", "inc"}], "}"}]}], "]"}]}], ";", 
      
      RowBox[{"cotas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmin", ",", 
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmin", ",", 
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmax", ",", 
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmax", ",", 
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ";", 
      RowBox[{"graf", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"func1", ",", "func2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "xmin", ",", "xmax"}], "}"}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "0.02`", "]"}], ",", "rects"}], "}"}], 
           "]"}], ",", "graf", ",", 
          RowBox[{"Graphics", "[", "cotas", "]"}]}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", "opts", ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           TagBox[
            FormBox[
             RowBox[{"\"\<Area \[TildeEqual]\>\"", "<>", 
              RowBox[{"ToString", "[", "area", "]"}]}],
             TraditionalForm],
            TraditionalForm,
            Editable->True], ",", 
           RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.40690885203125*^9, 3.406908858140625*^9}, 
   3.406908888453125*^9, {3.4069093003125*^9, 3.406909303578125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tipo1inf", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "xmin_", ",", "xmax_", ",", "sub_"}], "}"}], ",", 
     "opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rects", ",", "n", ",", "graf", ",", "inc", ",", "cotas", ",", 
       RowBox[{"area", "=", "0"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"inc", "=", 
       RowBox[{"N", "[", 
        FractionBox[
         RowBox[{"xmax", "-", "xmin"}], "sub"], "]"}]}], ";", 
      RowBox[{"rects", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"area", "=", 
               RowBox[{"area", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], "-", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], ")"}], " ", 
                 "inc"}]}]}], ";", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func1", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func2", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "inc", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "inc", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
                RowBox[{"Rectangle", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"n", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "inc"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"n", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], "}"}]}], "}"}], 
                 "]"}]}], "}"}]}], ")"}], "&"}], ")"}], "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Min", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "xmin", ",", 
           RowBox[{"xmax", "-", "inc"}], ",", "inc"}], "}"}]}], "]"}]}], ";", 
      
      RowBox[{"cotas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmin", ",", 
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmin", ",", 
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmax", ",", 
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmax", ",", 
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ";", 
      RowBox[{"graf", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"func1", ",", "func2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "xmin", ",", "xmax"}], "}"}], ",", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "2", "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "1", ",", "0"}], "]"}]}], "}"}]}], "}"}]}], 
         ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", "\[Rule]", 
            RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"graf", ",", 
          RowBox[{"Graphics", "[", "cotas", "]"}]}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        "opts", ",", 
        RowBox[{"Epilog", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "0.02`", "]"}], ",", "rects"}], "}"}]}], 
        ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           TagBox[
            FormBox[
             RowBox[{"\"\<Area \[TildeEqual]\>\"", "<>", 
              RowBox[{"ToString", "[", "area", "]"}]}],
             TraditionalForm],
            TraditionalForm,
            Editable->True], ",", 
           RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.406908909671875*^9, 3.40690891065625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tipo2", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "ymin_", ",", "ymax_"}], "}"}], ",", "opts___"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "graf", "}"}], ",", 
     RowBox[{
      RowBox[{"graf", "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"func1", ",", "var"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"func2", ",", "var"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "ymin", ",", "ymax"}], "}"}], ",", 
         RowBox[{"PlotStyle", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", ".013", "]"}], ",", 
            RowBox[{"Thickness", "[", ".013", "]"}]}], "}"}]}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"graf", ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Yellow", ",", 
               RowBox[{"Polygon", "[", 
                RowBox[{"Join", "[", 
                 RowBox[{
                  RowBox[{"graf", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1", ",", "3", ",", "3", ",", "1"}], 
                    "]"}], "]"}], ",", 
                  RowBox[{"Reverse", "[", 
                   RowBox[{"graf", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1", ",", "4", ",", "3", ",", "1"}], 
                    "]"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", ".0074", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"func1", "/.", 
                    RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"func2", "/.", 
                    RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], 
                   "}"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", ".0074", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"func1", "/.", 
                    RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"func2", "/.", 
                    RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], 
                   "}"}]}], "}"}], "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
        ",", "opts", ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.406918784875*^9, 3.40691879096875*^9}, {
   3.40691883075*^9, 3.406918856109375*^9}, {3.40691985540625*^9, 
   3.4069198579375*^9}, 3.406920031671875*^9, 3.40692008025*^9, {
   3.4069202244375*^9, 3.406920249671875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tipo2sup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "ymin_", ",", "ymax_", ",", "sub_"}], "}"}], ",", 
     "opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rects", ",", "n", ",", "graf", ",", "inc", ",", "cotas", ",", 
       RowBox[{"area", "=", "0"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"inc", "=", 
       RowBox[{"N", "[", 
        FractionBox[
         RowBox[{"ymax", "-", "ymin"}], "sub"], "]"}]}], ";", 
      RowBox[{"rects", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"area", "=", 
               RowBox[{"area", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], "-", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}]}], ")"}], " ", 
                 "inc"}]}]}], ";", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
                RowBox[{"Rectangle", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", "n"}], "}"}], ",", 
                  
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", "n"}], "}"}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", "n"}], "}"}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", "n"}], "}"}]}], 
                  "}"}], "]"}], ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", 
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func1", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Min", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", 
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func2", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}], 
             ")"}], "&"}], ")"}], "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Min", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "ymin", ",", 
           RowBox[{"ymax", "-", "inc"}], ",", "inc"}], "}"}]}], "]"}]}], ";", 
      
      RowBox[{"cotas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], "}"}]}], 
           "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], "}"}]}], 
           "}"}], "]"}]}], "}"}]}], ";", 
      RowBox[{"graf", "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"func1", ",", "var"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"func2", ",", "var"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "ymin", ",", "ymax"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.0085`", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.0085`", "]"}]}], "}"}]}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "0.02`", "]"}], ",", "rects"}], "}"}], 
           "]"}], ",", "graf", ",", 
          RowBox[{"Graphics", "[", "cotas", "]"}]}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        "opts", ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           TagBox[
            FormBox[
             RowBox[{"\"\<Area \[TildeEqual]\>\"", "<>", 
              RowBox[{"ToString", "[", "area", "]"}]}],
             TraditionalForm],
            TraditionalForm,
            Editable->True], ",", 
           RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4069088258125*^9, 3.406908830828125*^9}, 
   3.406908944828125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tipo2inf", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func1_", ",", "func2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "ymin_", ",", "ymax_", ",", "sub_"}], "}"}], ",", 
     "opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rects", ",", "n", ",", "graf", ",", "inc", ",", "cotas", ",", 
       RowBox[{"area", "=", "0"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"inc", "=", 
       RowBox[{"N", "[", 
        FractionBox[
         RowBox[{"ymax", "-", "ymin"}], "sub"], "]"}]}], ";", 
      RowBox[{"rects", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"area", "=", 
               RowBox[{"area", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], "-", 
                   RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}]}], ")"}], " ", 
                 "inc"}]}]}], ";", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", 
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func1", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "0", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", 
                   RowBox[{"Last", "[", 
                    RowBox[{"Last", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"func2", "/.", "\[InvisibleSpace]", 
                    RowBox[{"var", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "inc", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"n", "+", "j"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "inc", ",", "inc", ",", 
                    FractionBox["inc", "10"]}], "}"}]}], "]"}]}], "}"}], 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
                RowBox[{"Rectangle", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", "n"}], "}"}], ",", 
                  
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", "n"}], "}"}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", 
                    RowBox[{"n", "+", "inc"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"#1", ",", "#3"}], "]"}], ",", "n"}], "}"}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"#2", ",", "#4"}], "]"}], ",", "n"}], "}"}]}], 
                  "}"}], "]"}]}], "}"}]}], ")"}], "&"}], ")"}], "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Min", "[", 
            RowBox[{"func2", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}], ",", 
           
           RowBox[{"Max", "[", 
            RowBox[{"func1", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"n", "+", "j"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "0", ",", "inc", ",", 
                  FractionBox["inc", "10"]}], "}"}]}], "]"}]}]}], "]"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "ymin", ",", 
           RowBox[{"ymax", "-", "inc"}], ",", "inc"}], "}"}]}], "]"}]}], ";", 
      
      RowBox[{"cotas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymin"}]}], ",", "ymin"}], "}"}]}], 
           "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func1", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"func2", "/.", "\[InvisibleSpace]", 
               RowBox[{"var", "\[Rule]", "ymax"}]}], ",", "ymax"}], "}"}]}], 
           "}"}], "]"}]}], "}"}]}], ";", 
      RowBox[{"graf", "=", 
       RowBox[{"tipo2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"func1", ",", "func2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "ymin", ",", "ymax"}], "}"}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"graf", ",", 
          RowBox[{"Graphics", "[", "cotas", "]"}]}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        "opts", ",", 
        RowBox[{"Epilog", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "0.02`", "]"}], ",", "rects"}], "}"}]}], 
        ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           TagBox[
            FormBox[
             RowBox[{"\"\<Area \[TildeEqual]\>\"", "<>", 
              RowBox[{"ToString", "[", "area", "]"}]}],
             TraditionalForm],
            TraditionalForm,
            Editable->True], ",", 
           RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.40690896109375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cicloide", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rueda", ",", "rects", ",", "varilla", ",", "cic"}], "}"}], ",",
      
     RowBox[{
      RowBox[{
       RowBox[{"rueda", "[", "t_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".8", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t", ",", "1"}], "}"}], ",", "1"}], "]"}]}], "}"}]}], ";",
       " ", 
      RowBox[{"rects", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", ".01", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"14", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      " ", 
      RowBox[{
       RowBox[{"varilla", "[", 
        RowBox[{"r_", ",", "t_"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"t", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "-", 
               RowBox[{"r", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
              RowBox[{"1", "-", 
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "t", "]"}]}]}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", ".015", "]"}], ",", 
           RowBox[{"Hue", "[", "0", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "-", 
               RowBox[{"r", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
              RowBox[{"1", "-", 
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "t", "]"}]}]}]}], "}"}], "]"}]}], "}"}]}],
         "}"}]}], ";", " ", 
      RowBox[{
       RowBox[{"cic", "[", "t_", "]"}], ":=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"u", "-", " ", 
            RowBox[{"Sin", "[", "u", "]"}]}], ",", 
           RowBox[{"1", "-", " ", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u", ",", "0", ",", "t"}], "}"}], ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"Hue", "[", "0", "]"}]}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      RowBox[{"Animate", "[", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"rects", ",", 
               RowBox[{"rueda", "[", "t", "]"}], ",", 
               RowBox[{"varilla", "[", 
                RowBox[{"1", ",", "t"}], "]"}]}], "}"}], "]"}], ",", 
            RowBox[{"cic", "[", "t", "]"}]}], "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
          " ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "14"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2.1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", ".01", ",", 
          RowBox[{
           RowBox[{"4", "Pi"}], "+", ".01"}], ",", 
          RowBox[{"2", 
           RowBox[{"Pi", "/", "10"}]}]}], "}"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.40691498825*^9, 3.406914989578125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cardioide", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rueda", ",", "radio", ",", "circulo"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"rueda", "[", "t_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".7", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Cos", "[", "t", "]"}]}], "+", "1"}], ",", 
             RowBox[{"2", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", "1"}], "]"}]}], 
        "}"}]}], ";", 
      RowBox[{
       RowBox[{"circulo", "[", "t_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", "0.6", "]"}], ",", 
         RowBox[{"Thickness", "[", ".007", "]"}], ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Cos", "[", "t", "]"}]}], "+", "1"}], ",", 
             RowBox[{"2", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", "1"}], "]"}]}], 
        "}"}]}], ";", " ", 
      RowBox[{
       RowBox[{"radio", "[", "t_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"2", 
                RowBox[{"Cos", "[", "t", "]"}]}], "+", "1"}], ",", 
              RowBox[{"2", 
               RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", "t", "]"}]}], ")"}], 
               RowBox[{"4", "/", "2"}], 
               RowBox[{"Cos", "[", "t", "]"}]}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", "t", "]"}]}], ")"}], " ", 
               RowBox[{"4", "/", "2"}], " ", 
               RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}]}], " ", "}"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", ".02", "]"}], ",", 
           RowBox[{"Hue", "[", "0", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", "t", "]"}]}], ")"}], " ", 
               RowBox[{"4", "/", "2"}], 
               RowBox[{"Cos", "[", "t", "]"}]}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", "t", "]"}]}], ")"}], 
               RowBox[{"4", "/", "2"}], 
               RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], " ", "]"}]}], 
          "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Animate", "[", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ParametricPlot", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"Cos", "[", "u", "]"}]}], ")"}], "2", 
                 RowBox[{"Cos", "[", "u", "]"}]}], ",", 
                RowBox[{"2", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"Cos", "[", "u", "]"}]}], ")"}], 
                 RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], " ", ",", 
              RowBox[{"{", 
               RowBox[{"u", ",", "0", ",", 
                RowBox[{"t", "+", ".01"}]}], "}"}], ",", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Hue", "[", "0", "]"}], ",", 
                 RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}]}], ",", 
              RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], 
            ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"circulo", "[", "t", "]"}], ",", 
               RowBox[{"radio", "[", "t", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Hue", "[", "0.6", "]"}], ",", 
                 RowBox[{"Thickness", "[", ".007", "]"}], ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}], ",", "1"}], "]"}]}], 
                "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"Axes", "\[Rule]", "True"}], ",", 
          RowBox[{"Prolog", "\[Rule]", 
           RowBox[{"rueda", "[", "t", "]"}]}], ",", 
          RowBox[{"Ticks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", 
               RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", 
               ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "2"}], ",", 
               RowBox[{"-", "3"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
            "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3.2"}], ",", "4.2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3.2"}], ",", "3.2"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}],
         ",", " ", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"Pi", "/", "10"}]}], "}"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.406914977765625*^9, 3.40691497990625*^9}, {
  3.406921027171875*^9, 3.406921033953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ArcLengthPartition", "[", 
    RowBox[{"parametrizedCurve_Function", ",", 
     RowBox[{"{", 
      RowBox[{"tmin_", ",", "tmax_"}], "}"}], ",", "n_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "L", ",", "s", ",", "f", ",", "t"}], "}"}],
       ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "=", 
        RowBox[{"N", "[", 
         RowBox[{"{", 
          RowBox[{"tmin", ",", "tmax"}], "}"}], "]"}]}], ";", 
       RowBox[{"L", "=", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          SqrtBox[
           RowBox[{"Plus", "@@", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["parametrizedCurve", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}]], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "a", ",", "b"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"s", "=", 
        RowBox[{
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
              SqrtBox[
               RowBox[{"Plus", "@@", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["parametrizedCurve", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "2"]}]]}], ",", 
             
             RowBox[{
              RowBox[{"f", "[", "a", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
           "f", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"a", "-", "L"}], ",", 
             RowBox[{"b", "+", "L"}]}], "}"}]}], "]"}], 
         "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";", 
       
       RowBox[{"Transpose", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", "/.", "\[InvisibleSpace]", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"s", "[", "t", "]"}], "\[Equal]", "#1"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "b"}], "}"}]}], "}"}]}], "]"}]}], "&"}], 
          ")"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", 
           RowBox[{"s", "[", "b", "]"}], ",", 
           FractionBox[
            RowBox[{"s", "[", "b", "]"}], "n"]}], "]"}]}], "]"}]}]}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ArcLengthPartition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"exprX_", ",", "exprY_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t_Symbol", ",", "tmin_", ",", "tmax_"}], "}"}], ",", "n_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"ArcLengthPartition", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "t", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"exprX", ",", "exprY"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"tmin", ",", "tmax"}], "}"}], ",", "n"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"NumberQ", "[", 
      RowBox[{"N", "[", "tmin", "]"}], "]"}], "&&", 
     RowBox[{"NumberQ", "[", 
      RowBox[{"N", "[", "tmax", "]"}], "]"}], "&&", 
     RowBox[{"NumberQ", "[", 
      RowBox[{"N", "[", "n", "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lineapuntos", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"funcx_", ",", "funcy_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"var_", ",", "tmin_", ",", "tmax_"}], "}"}], ",", "n_"}], "]"}], 
  ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0", "]"}], ",", 
       RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
       RowBox[{"Point", "/@", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"funcx", "/.", "\[InvisibleSpace]", 
            RowBox[{"var", "\[Rule]", 
             RowBox[{"ArcLengthPartition", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}], 
              "]"}]}]}], ",", 
           RowBox[{"funcy", "/.", "\[InvisibleSpace]", 
            RowBox[{"var", "\[Rule]", 
             RowBox[{"ArcLengthPartition", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}], 
              "]"}]}]}]}], "}"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0", "]"}], ",", 
       RowBox[{"Map", "[", 
        RowBox[{"Line", ",", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"funcx", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"ArcLengthPartition", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}],
                "]"}]}]}], ",", 
            RowBox[{"funcy", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"ArcLengthPartition", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}],
                "]"}]}]}]}], "}"}], "]"}], ",", 
         RowBox[{"{", "0", "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"arclength", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"funcx_", ",", "funcy_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "tmin_", ",", "tmax_"}], "}"}], ",", "n_", ",", 
     "opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "aproxlong"}], "}"}], ",", 
     RowBox[{
      RowBox[{"u", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"funcx", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"ArcLengthPartition", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}],
                "]"}]}]}], ",", 
            RowBox[{"funcy", "/.", "\[InvisibleSpace]", 
             RowBox[{"var", "\[Rule]", 
              RowBox[{"ArcLengthPartition", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}],
                "]"}]}]}]}], "}"}], "]"}], ",", 
         RowBox[{"-", "1"}]}], "]"}]}], ";", 
      RowBox[{"v", "=", 
       RowBox[{"Rest", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"funcx", "/.", "\[InvisibleSpace]", 
            RowBox[{"var", "\[Rule]", 
             RowBox[{"ArcLengthPartition", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}], 
              "]"}]}]}], ",", 
           RowBox[{"funcy", "/.", "\[InvisibleSpace]", 
            RowBox[{"var", "\[Rule]", 
             RowBox[{"ArcLengthPartition", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}], 
              "]"}]}]}]}], "}"}], "]"}], "]"}]}], ";", 
      RowBox[{"aproxlong", "=", 
       RowBox[{"Plus", "@@", 
        SqrtBox[
         RowBox[{"Apply", "[", 
          RowBox[{"Plus", ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"u", "-", "v"}], ")"}], "2"], ",", "1"}], "]"}]]}]}], 
      ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ParametricPlot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "opts", 
            ",", 
            RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
          
          RowBox[{"lineapuntos", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"funcx", ",", "funcy"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"var", ",", "tmin", ",", "tmax"}], "}"}], ",", "n"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           TagBox[
            FormBox[
             RowBox[{"\"\<Longitud \[TildeEqual]\>\"", "<>", 
              RowBox[{"ToString", "[", "aproxlong", "]"}]}],
             TraditionalForm],
            TraditionalForm,
            Editable->True], ",", 
           RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"fig", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "cartesianas", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"cartesianas", "[", 
        RowBox[{"{", 
         RowBox[{"\[Rho]_", ",", "\[Theta]_"}], "}"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PolarPlot", "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Theta]", ",", 
              RowBox[{"\[Pi]", "/", "20"}], ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"Axes", "\[Rule]", "None"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
               RowBox[{"Hue", "[", "0", "]"}]}], "}"}]}], ",", 
            RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
          
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
               RowBox[{"Hue", "[", "0", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0.6", ",", 
                    RowBox[{"-", ".5"}]}], "}"}], ",", 
                  RowBox[{"cartesianas", "[", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"\[Pi]", "/", "2"}]}], "}"}], "]"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.6", ",", 
                  RowBox[{"-", ".5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2.1", ",", 
                  RowBox[{"-", ".5"}]}], "}"}]}], "}"}], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", ".4", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "+", ".37"}]}], "}"}]}], "]"}],
              ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", "1.1", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "20"}], "+", ".38"}]}], "}"}]}], 
              "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", ".6", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "+", ".037"}]}], "}"}]}], 
              "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<\[Alpha]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"1.6", ",", 
                 RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<\[Beta]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{".85", ",", 
                 RowBox[{"-", ".25"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<\[Rho]=f(\[Theta])\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"1.5", ",", "1.25"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(k - 1\)]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"1.2", ",", ".16"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<\[CapitalOmega]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"1.2", ",", ".7"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(k\)]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", ".02"}], "}"}]}], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", ".8", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "-", ".255"}]}], "}"}]}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0.6", ",", 
                    RowBox[{"-", ".5"}]}], "}"}], ",", 
                  RowBox[{"cartesianas", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "-", ".7"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "-", ".7"}]}], "}"}], 
                   "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0.6", ",", 
                    RowBox[{"-", ".5"}]}], "}"}], ",", 
                  RowBox[{"cartesianas", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], " ", "-", ".4"}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "-", ".4"}]}], "}"}], 
                   "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
               RowBox[{"Hue", "[", "0", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0.6", ",", 
                    RowBox[{"-", ".5"}]}], "}"}], ",", 
                  RowBox[{"cartesianas", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Pi]", "/", "20"}], "]"}]}], ",", 
                    RowBox[{"\[Pi]", "/", "20"}]}], "}"}], "]"}]}], "}"}], 
                "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"Prolog", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Hue", "[", ".5", "]"}], ",", 
             RowBox[{"Disk", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", "1.775", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "-", ".255"}], ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "+", ".037"}]}], "}"}]}], 
              "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Dashing", "[", 
              RowBox[{"{", 
               RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{".6", ",", 
                 RowBox[{"-", ".5"}]}], "}"}], ",", "1.775", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "-", ".255"}], ",", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "2"}], "+", ".037"}]}], "}"}]}], 
              "]"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", ".6"}], ",", "2.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", ".6"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{".75", "*", 
          RowBox[{"{", 
           RowBox[{"394", ",", "379.375"}], "}"}]}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
        RowBox[{"TextStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
           RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "}"}]}]}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.40692135928125*^9, 3.406921437046875*^9}, {
  3.406921495921875*^9, 3.4069215271875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fig2", ":=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1.5"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "2"}], ",", "1.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", ".5", "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"1", "/", "2"}], "-", ".01"}], ",", "1.5"}], "}"}]}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".8", ",", "3.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".8", ",", 
             RowBox[{"-", ".1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3.2", ",", 
             RowBox[{"-", ".1"}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"Y", ",", 
          RowBox[{"{", 
           RowBox[{"0.09", ",", 
            RowBox[{"-", "1.8"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"Z", ",", 
          RowBox[{"{", 
           RowBox[{"0.85", ",", "3.4"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"X", ",", 
          RowBox[{"{", 
           RowBox[{"3.15", ",", "0.1"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"a", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"b", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"2.5", ",", 
            RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<\[CapitalOmega](x)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<\[CapitalOmega]\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".8", ",", 
             RowBox[{"-", ".1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.1", ",", 
             RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             RowBox[{"(", "1.5", ")"}], "/", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Pi]", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.5", ",", 
               RowBox[{"-", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "3.95"}], "}"}]}], "}"}], "]"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2.5", ",", "3.89"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "3.95"}], "}"}]}], "}"}], "]"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2.5", ",", "3.89"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2.5", ",", 
               RowBox[{"-", ".11"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"-", ".1"}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", ".1"}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2.5", ",", 
               RowBox[{"-", ".11"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", 
               RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", "1.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"3", 
               RowBox[{"\[Pi]", "/", "2"}]}], ",", 
              RowBox[{"5", 
               RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{".012", ",", ".012"}], "}"}], "]"}], ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{
               RowBox[{"(", "1.5", ")"}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "2.2"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"681", ",", "226.813"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "3.3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.2"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"TextStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
        RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4069126691875*^9, 3.40691267425*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fig3", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "f", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x_", "]"}], "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"UnitStep", "[", 
               RowBox[{"x", "-", 
                RowBox[{"(", 
                 RowBox[{"k", "+", 
                  FractionBox["1", "5"]}], ")"}]}], "]"}]}], "+", 
             RowBox[{"UnitStep", "[", 
              RowBox[{"x", "-", "k"}], "]"}]}], ")"}], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox[
              SuperscriptBox["k", "2"], "4"]}]]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"-", "2"}], ",", 
            RowBox[{"2", "+", 
             FractionBox["1", "5"]}], ",", 
            FractionBox["1", "5"]}], "}"}]}], "]"}]}]}], ";", 
      RowBox[{"RevolutionPlot3D", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"RevolutionAxis", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
        RowBox[{"ViewPoint", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.012`"}], ",", 
           RowBox[{"-", "3.277`"}], ",", "0.845`"}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"510", ",", "283.75`"}], "}"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"LightSources", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0", ",", "1", ",", "1"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0", ",", "1", ",", "1"}], "]"}]}], "}"}]}], "}"}]}]}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"stepfunc", "[", 
   RowBox[{"func_", ",", 
    RowBox[{"{", 
     RowBox[{"var_", ",", "xmin_", ",", "xmax_"}], "}"}], ",", "n_"}], "]"}], 
  ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"UnitStep", "[", 
           RowBox[{"x", "-", 
            RowBox[{"(", 
             RowBox[{"k", "+", 
              RowBox[{"N", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"xmax", "-", "xmin"}], ")"}], "/", "n"}], "]"}]}], 
             ")"}]}], "]"}]}], "+", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"x", "-", "k"}], "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"func", "/.", 
         RowBox[{"var", "\[Rule]", "k"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "xmin", ",", "xmax", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"xmax", "-", "xmin"}], ")"}], "/", "n"}], "]"}]}], "}"}]}],
      "]"}]}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"disco1", "[", 
    RowBox[{"func_", ",", 
     RowBox[{"{", 
      RowBox[{"var_", ",", "xmin_", ",", "xmax_", ",", "sub_"}], "}"}], ",", 
     "opts___"}], "]"}], ":=", "\[IndentingNewLine]", "\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rects", ",", "n", ",", "graf", ",", "inc", ",", "cotas"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"inc", "=", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"xmax", " ", "-", " ", "xmin"}], ")"}], "/", "sub"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rects", " ", "=", " ", 
       RowBox[{"Table", "[", "\n", "\t\t\t\t", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"n", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"n", "+", "inc"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"n", "+", "inc"}], ",", "#"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "#"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "0"}], "}"}]}], "}"}], "]"}], ")"}], "&"}], 
          "[", 
          RowBox[{"Min", "[", 
           RowBox[{"func", "/.", 
            RowBox[{"var", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"n", "+", "inc"}]}], "}"}]}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "xmin", ",", 
           RowBox[{"xmax", "-", " ", "inc"}], ",", "inc"}], "}"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", "\t\t", 
      RowBox[{"cotas", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmin", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmin", ",", 
              RowBox[{"func", "/.", 
               RowBox[{"var", "\[Rule]", "xmin"}]}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmax", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmax", ",", 
              RowBox[{"func", "/.", 
               RowBox[{"var", "\[Rule]", "xmax"}]}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xmin", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"xmax", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"graf", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{"func", ",", " ", 
         RowBox[{"{", 
          RowBox[{"var", ",", "xmin", ",", "xmax"}], "}"}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
      " ", "\[IndentingNewLine]", "\t", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"graf", ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"cotas", ",", "rects"}], "}"}], "]"}]}], "}"}], ",", 
        "opts", ",", 
        RowBox[{"AxesOrigin", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"xmin", "-", ".2"}], ",", "0"}], "]"}], ",", "0"}], 
          "}"}]}]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"fig4", ":=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "+", 
            RowBox[{"Sin", "[", "x", "]"}]}], ",", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", ".5", ",", 
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", ".5"}]}], "}"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".5", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".3", ",", 
              RowBox[{"2", "+", 
               RowBox[{"Sin", "[", ".5", "]"}]}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".25", ",", 
              RowBox[{"2", "+", 
               RowBox[{"Sin", "[", "3", "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"3", "-", ".7"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".25", ",", 
              RowBox[{"2", "+", 
               RowBox[{"Sin", "[", 
                RowBox[{"3", "-", ".7"}], "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"3", "-", ".7"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{".25", ",", 
                RowBox[{"2", "+", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"3", "-", ".7"}], "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\[Pi]", "/", "2"}], ",", 
                RowBox[{"3", 
                 RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"2", "\[Pi]"}], "-", ".5"}], ",", "0"}], "}"}], ",", 
              
              RowBox[{"{", 
               RowBox[{".23", ",", 
                RowBox[{"2", "+", 
                 RowBox[{"Sin", "[", 
                  RowBox[{
                   RowBox[{"2", "\[Pi]"}], "-", ".5"}], "]"}]}]}], "}"}], ",",
               
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\[Pi]", "/", "2"}], ",", 
                RowBox[{"3", 
                 RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"2.3", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2.3", ",", 
                 RowBox[{"2", "+", 
                  RowBox[{"Sin", "[", "2.3", "]"}]}]}], "}"}]}], "}"}], 
             "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"3", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", 
                 RowBox[{"2", "+", 
                  RowBox[{"Sin", "[", "3", "]"}]}]}], "}"}]}], "}"}], "]"}]}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{".01", ",", ".01"}], "}"}], "]"}], ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{".25", ",", 
                RowBox[{"2", "+", 
                 RowBox[{"Sin", "[", "3", "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\[Pi]", "/", "2"}], ",", 
                RowBox[{"3", 
                 RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<a\>\"", ",", 
            RowBox[{"{", 
             RowBox[{".5", ",", 
              RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<b\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "\[Pi]"}], "-", ".5"}], ",", 
              RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<y=f(x)\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"4.5", ",", "1.55"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<S(x)\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"1.5", ",", "1.35"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<L(x)\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"2.75", ",", 
              RowBox[{"2.45", "+", 
               RowBox[{"Sin", "[", "2.7", "]"}]}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<L(x+h)\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"3.65", ",", 
              RowBox[{"2.1", "+", 
               RowBox[{"Sin", "[", "3", "]"}]}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<x\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"2.3", ",", 
              RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<x+h\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", 
              RowBox[{"-", ".2"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "\[Pi]"}], "-", ".5"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".23", ",", 
              RowBox[{"2", "+", 
               RowBox[{"Sin", "[", 
                RowBox[{
                 RowBox[{"2", "\[Pi]"}], "-", ".5"}], "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}],
       "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".1"}], ",", 
          RowBox[{
           RowBox[{"2", "\[Pi]"}], "+", ".1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.1"}], ",", "3.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
     RowBox[{"TextStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".5", ",", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2.3", ",", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", ".5"}], ",", "\"\<\>\""}], "}"}]}], 
         "}"}], ",", "None"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.406912409375*^9, 3.4069124630625*^9}, {
  3.40691256709375*^9, 3.406912576515625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de \[AAcute]reas planas", "Section"],

Cell[TextData[{
 "Te recuerdo que si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
    "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
 " es una funci\[OAcute]n continua, representamos por ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", 
    StyleBox["(",
     FontSize->12], 
    StyleBox[
     RowBox[{"f", ",", "a", ",", "b"}],
     FontSize->12], 
    StyleBox[")",
     FontSize->12]}], TraditionalForm]]],
 " la regi\[OAcute]n del plano comprendida entre la curva ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", " ", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 ", el eje de abscisas y las rectas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "a"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "b"}], TraditionalForm]]],
 ". Como sabes, el \[AAcute]rea de dicha regi\[OAcute]n viene dada por ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"G", "(", 
      RowBox[{"f", ",", "a", ",", "b"}], ")"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "a"], "b"], 
     RowBox[{"|", 
      RowBox[{"f", "(", "x", ")"}], "|", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]]],
 " (no suponemos que ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " sea positiva). Es interesante interpretar la integral que proporciona el \
\[AAcute]rea de la siguiente forma. Observa que ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "(", "x", ")"}], "|"}], TraditionalForm]]],
 " es la ",
 StyleBox["longitud",
  FontSlant->"Italic"],
 " del segmento intersecci\[OAcute]n de ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", 
    StyleBox["(",
     FontSize->12], 
    StyleBox[
     RowBox[{"f", ",", "a", ",", "b"}],
     FontSize->12], 
    StyleBox[")",
     FontSize->12]}], TraditionalForm]]],
 " con la recta vertical que pasa por ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "0"}], ")"}], TraditionalForm]]],
 ", es decir, ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"|", 
     RowBox[{"f", "(", "x", ")"}], "|"}],
    FontWeight->"Plain"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "es la longitud de",
 StyleBox[" ",
  FontWeight->"Bold"],
 "la",
 StyleBox[" secci\[OAcute]n vertical ",
  FontWeight->"Bold"],
 "de ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", 
    StyleBox["(",
     FontSize->12], 
    StyleBox[
     RowBox[{"f", ",", "a", ",", "b"}],
     FontSize->12], 
    StyleBox[")",
     FontSize->12]}], TraditionalForm]]],
 " por el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "0"}], ")"}], TraditionalForm]]],
 ", y",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["el \[AAcute]rea de la regi\[OAcute]n  ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "(", 
    RowBox[{"f", ",", "a", ",", "b"}], ")"}], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox[" es igual a la integral de las longitudes de sus secciones",
  FontSlant->"Italic"],
 ". Intuitivamente: integrando longitudes obtenemos \[AAcute]reas. Como el \
\[AAcute]rea es invariante por rotaciones, este resultado es tambi\[EAcute]n \
v\[AAcute]lido si consideramos secciones por rectas paralelas a una recta \
cualquiera dada. Deducimos as\[IAcute] el siguiente resultado.\n",
 StyleBox["Principio de Cavalieri",
  FontWeight->"Bold"],
 ". ",
 StyleBox["El \[AAcute]rea de una regi\[OAcute]n plana es igual a la integral \
de las longitudes de sus secciones por rectas paralelas a una recta dada",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". \nVeamos c\[OAcute]mo se aplica este principio en algunos casos \
concretos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  \[CapitalAAcute]rea entre dos curvas", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
 "  ",
 StyleBox["Regiones de tipo I",
  FontSize->16]
}], "Subsubsection",
 FontSize->12],

Cell[TextData[{
 "Supongamos que ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"f", ",", 
     RowBox[{
      RowBox[{"g", ":", 
       RowBox[{"[", 
        RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
      "\[DoubleStruckCapitalR]"}]}],
    FontSize->13], TraditionalForm]]],
 " son funciones continuas y llamemos \[CapitalOmega] a la regi\[OAcute]n del \
plano comprendida entre las curvas ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     FontSize->14], 
    StyleBox["=",
     FontSize->13], 
    StyleBox[" ",
     FontSize->13], 
    StyleBox[
     RowBox[{"f", "(", "x", ")"}],
     FontSize->13]}], TraditionalForm]]],
 " e ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"y", "=", 
     RowBox[{"g", "(", "x", ")"}]}]}], TraditionalForm]]],
 " para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], TraditionalForm]]],
 ". Se dice que \[CapitalOmega] es una regi\[OAcute]n de tipo I. Puedes \
representar gr\[AAcute]ficamente dicha regi\[OAcute]n con la orden \
\"tipo1[{f,g},{x,a,b},opts]\" (que admite opciones como \"Plot\"). \
Experimenta con distintas funciones. Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[
 RowBox[{"tipo1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.406910087875*^9, 3.40691127853125*^9}],

Cell[BoxData[
 RowBox[{"tipo1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{"4", "-", 
      SuperscriptBox["x", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", ".65", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.406910109078125*^9}],

Cell[BoxData[
 RowBox[{"tipo1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", ".65", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.406910109078125*^9, {3.40691519684375*^9, 3.406915210921875*^9}, {
   3.4069152436875*^9, 3.406915244359375*^9}}],

Cell[TextData[{
 "Es evidente que las longitudes de las secciones verticales de \
\[CapitalOmega] son iguales a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], "-", 
     RowBox[{"g", "(", "x", ")"}]}], "|"}], TraditionalForm]]],
 " por lo que su \[AAcute]rea viene dada por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], "-", 
      RowBox[{"g", "(", "x", ")"}]}], "|", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Observa que esta integral expresa el \[AAcute]rea de \[CapitalOmega] como l\
\[IAcute]mite de las sumas de Riemann ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", 
       SubscriptBox["t", "k"], ")"}], "-", 
      RowBox[{"g", "(", 
       SubscriptBox["t", "k"], ")"}]}], "|", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", 
        RowBox[{"k", "+", "1"}]], "-", 
       SubscriptBox["x", "k"]}], ")"}]}]}], TraditionalForm]]],
 ", lo que tiene una sencilla interpretaci\[OAcute]n que puedes visualizar \
con la orden \"tipo1sup[{f,g},{x,a,b,n},opts]\" (admite opciones como \
\"Plot\") que representa aproximaciones superiores al \[AAcute]rea de \
\[CapitalOmega] dividiendo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 " en ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " subintervalos ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["x", "k"], ",", 
     SubscriptBox["x", 
      RowBox[{"k", "+", "1"}]]}], "]"}], TraditionalForm]]],
 " y eligiendo en cada uno de ellos el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "k"], " ", "\[Epsilon]", "  ", 
    FormBox[
     RowBox[{"[", 
      RowBox[{
       SubscriptBox["x", "k"], ",", 
       SubscriptBox["x", 
        RowBox[{"k", "+", "1"}]]}], "]"}],
     TraditionalForm], " "}], TraditionalForm]]],
 " en el que la funci\[OAcute]n",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "-", "g"}], "|"}], TraditionalForm]]],
 " alcanza su m\[AAcute]ximo absoluto en dicho subintervalo. Significado an\
\[AAcute]logo tiene el comando \"tipo1inf[{f,g},{x,a,b,n},opts]\". Prueba con \
distintas funciones. Los siguientes ejemplos son ilustrativos."
}], "Text"],

Cell[BoxData[
 RowBox[{"tipo1sup", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}], ",", "24"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.40691013321875*^9}],

Cell[BoxData[
 RowBox[{"tipo1inf", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}], ",", "24"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.406910142359375*^9}],

Cell["\<\
Las siguientes animaciones muestarn c\[OAcute]mo las aproximaciones van \
mejorando conforme aumenta el n\[UAcute]mero de intervalos de la partici\
\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"tipo1sup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", "k"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12", ",", "36", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40691015328125*^9, 3.40691016253125*^9}}],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"tipo1inf", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", "k"}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12", ",", "36", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.406910179*^9, 3.406910185765625*^9}}],

Cell[TextData[{
 "En la pr\[AAcute]ctica, es frecuente describir una regi\[OAcute]n de tipo I \
como ",
 StyleBox["\"la regi\[OAcute]n comprendida entre las curvas",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", " ", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " ",
 StyleBox["e",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"y", "=", 
     RowBox[{"g", "(", "x", ")"}]}]}], TraditionalForm]]],
 StyleBox["\"",
  FontSlant->"Italic"],
 " sin precisar el intervalo de la variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ". En estos casos, se entiende que se trata de la ",
 StyleBox["regi\[OAcute]n acotada",
  FontSlant->"Italic"],
 " comprendidad entre las dos gr\[AAcute]ficas; la cual debe determinarse \
calculando los puntos de intersecci\[OAcute]n de las mismas, es decir, \
resolviendo la ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"g", "(", "x", ")"}]}], TraditionalForm]]],
 " lo que tambi\[EAcute]n nos proporciona los l\[IAcute]mites de integraci\
\[OAcute]n ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ". "
}], "Text"],

Cell[TextData[{
 StyleBox["Cuando la funci\[OAcute]n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " ", "-", " ", "g"}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" no tiene signo constante en el intervalo ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[", para calcular la integral ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", "a"], "b"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], "-", 
      RowBox[{"g", "(", "x", ")"}]}], "|", 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" se descompone dicho  intervalo en intervalos en los que la funci\
\[OAcute]n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " ", 
    RowBox[{"-", " ", "g"}], " "}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox["es siempre positiva o siempre negativa, lo que permite quitar el \
valor absoluto en el integrando. ",
  FontWeight->"Bold"],
 "\nA veces interesa expresar una regi\[OAcute]n de tipo I como uni\[OAcute]n \
de dos o m\[AAcute]s regiones de tipo I disjuntas y m\[AAcute]s sencillas, \
entonces su \[AAcute]rea es la suma de las \[AAcute]reas de cada una de \
dichas regiones."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 1", "Subsubsection"],

Cell[TextData[{
 "Calcular el \[AAcute]rea de la region \[CapitalOmega] comprendida entre la \
par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"2", "x"}], "+", "10"}]}], TraditionalForm]]],
 " y la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"2", "x"}], "-", "1"}]}], TraditionalForm]]],
 "."
}], "Text"],

Cell["\<\
Calculamos los puntos donde se cortan la par\[AAcute]bola y la recta. \
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"2", "x"}], "+", "10"}]}], ",", "x"}], "]"}]}]}]], "Input"],

Cell["\<\
Representaremos la regi\[OAcute]n \[CapitalOmega]. Puedes usar para ello la \
orden \"Plot[ ]\". \
\>", "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"2", "x"}], "+", "10"}], ",", 
     RowBox[{
      RowBox[{"2", "x"}], "-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", ".65", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.406910239203125*^9, {3.406912068625*^9, 3.40691208165625*^9}, {
   3.4069121278125*^9, 3.4069121368125*^9}}],

Cell[TextData[{
 "Es claro que para  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SqrtBox["15"]}], ",", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["15"]}]}], "]"}]}], TraditionalForm]]],
 "   la par\[AAcute]bola est\[AAcute] por encima de la recta. Por tanto, el \
\[AAcute]rea de \[CapitalOmega] viene dada por \t      \t \t\t"
}], "Text"],

Cell[BoxData[{
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"2", "x"}], "+", "10", "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}], "\n", 
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 2", "Subsubsection"],

Cell[TextData[{
 "Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] comprendida \
entre la par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", "x"}], TraditionalForm]]],
 " y la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"x", "-", "2"}]}], TraditionalForm]]],
 "."
}], "Text"],

Cell[TextData[{
 "Calculemos los puntos de corte de la recta",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{"y", "=", 
      RowBox[{"x", "-", "2"}]}],
     TraditionalForm]}], TraditionalForm]]],
 " con la par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", "x"}], TraditionalForm]]],
 ". "
}], "Text"],

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "2"]}], ",", "x"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["x"], ",", 
     RowBox[{"x", "-", "2"}], ",", 
     RowBox[{"-", 
      SqrtBox["x"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", ".65", "]"}], ",", 
        RowBox[{"Thickness", "[", ".007", "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.406910277890625*^9}],

Cell[TextData[{
 "F\[IAcute]jate en que la  par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", "x"}], TraditionalForm]]],
 " es la uni\[OAcute]n de las dos curvas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SqrtBox["x"]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"-", 
     SqrtBox["x"]}]}], TraditionalForm]]],
 ", por lo que la frontera de \[CapitalOmega] est\[AAcute] determinada por \
dichas curvas y la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"x", "-", "2"}]}], TraditionalForm]]],
 ". Es claro que \[CapitalOmega] es uni\[OAcute]n de dos regiones de tipo I. \
"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalOmega]1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["x"]}], ",", 
       SqrtBox["x"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalOmega]2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "-", "2"}], ",", 
       SqrtBox["x"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "2", "}"}], ",", "Orange"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[CapitalOmega]1", ",", "\[CapitalOmega]2", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(\[CapitalOmega]\), \(1\)]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".6", ",", ".3"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(\[CapitalOmega]\), \(2\)]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1.9", ",", ".8"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", "All"}], "}"}]}], ",", 
   RowBox[{"DisplayFunction", "->", "$DisplayFunction"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"1", ",", "4"}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"TextStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
      RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.406910287609375*^9, {3.4069103725*^9, 3.4069104475*^9}, {
   3.406910483359375*^9, 3.406910521890625*^9}, {3.406915347875*^9, 
   3.406915437015625*^9}}],

Cell[TextData[{
 "Tenemos que el \[AAcute]rea de \[CapitalOmega] viene dada por  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
    RowBox[{
     RowBox[{"\[Lambda]", "(", "\[CapitalOmega]1", ")"}], "+", 
     RowBox[{"\[Lambda]", "(", "\[CapitalOmega]2", ")"}]}]}], 
   TraditionalForm]]],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SqrtBox["x"], "-", 
        RowBox[{"(", 
         RowBox[{"-", 
          SqrtBox["x"]}], ")"}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "+", " ", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "1", "4"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SqrtBox["x"], "-", 
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["x"], "-", 
     RowBox[{"(", 
      RowBox[{"-", 
       SqrtBox["x"]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["x"], "-", 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "Observa que \[CapitalOmega] es ella misma una regi\[OAcute]n de tipo I \
definida por las funciones ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox["f",
     TraditionalForm], ",", 
    FormBox[
     RowBox[{"g", ":", 
      RowBox[{
       RowBox[{"[", 
        RowBox[{"0", ",", "4"}], "]"}], "\[RightArrow]", 
       "\[DoubleStruckCapitalR]"}]}],
     TraditionalForm]}], TraditionalForm]]],
 " dadas por ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "=", 
    SqrtBox["x"]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"-", 
     SqrtBox["x"]}]}], TraditionalForm]]],
 ", para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", " ", "x", "\[LessEqual]", " ", "1"}], 
   TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"x", "-", "2"}]}], TraditionalForm]]],
 ", para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", " ", "x", "\[LessEqual]", " ", "4"}], 
   TraditionalForm]]],
 ".  "
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "g"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["x"]}], "/;", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "1"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "-", "2"}], "/;", 
    RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "4"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   SqrtBox["x"]}], ";"}], "\n", 
 RowBox[{"tipo1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "g"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.40691055915625*^9, 3.406910561828125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Regiones de tipo II", "Subsubsection"],

Cell[TextData[{
 "Supongamos que ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ",", 
    RowBox[{
     RowBox[{"g", ":", 
      RowBox[{"[", 
       RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
     "\[DoubleStruckCapitalR]"}]}], TraditionalForm]]],
 " son funciones continuas y llamemos \[CapitalOmega] a la regi\[OAcute]n del \
plano comprendida entre las curvas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", " ", 
    RowBox[{"f", "(", "y", ")"}]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"x", "=", 
     RowBox[{"g", "(", "y", ")"}]}]}], TraditionalForm]]],
 " para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], TraditionalForm]]],
 ". Se dice que \[CapitalOmega] es una regi\[OAcute]n de tipo II. Puedes \
representar gr\[AAcute]ficamente una regi\[OAcute]n de tipo II con la orden \
\"tipo2[{f,g},{y,a,b},opts]\" (que admite opciones como \"Show\"). \
Experimenta con distintas funciones. Observa que las regiones de tipo II son \
las sim\[EAcute]tricas de las regiones de tipo I respecto de la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "x"}], TraditionalForm]]],
 ". Es decir, una regi\[OAcute]n de tipo II es una regi\[OAcute]n de tipo I \
vista desde el eje de ordenadas. Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[
 RowBox[{"tipo2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "y", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "y", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.40691099003125*^9, {3.4069201379375*^9, 3.406920151296875*^9}, 
   3.406920369859375*^9, {3.4069204240625*^9, 3.406920443015625*^9}}],

Cell[BoxData[
 RowBox[{"tipo2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["y", "2"], ",", 
     RowBox[{"4", "-", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.40691099003125*^9, {3.4069201379375*^9, 3.406920151296875*^9}, 
   3.406920369859375*^9}],

Cell[TextData[{
 "Es evidente que las longitudes de las ",
 StyleBox["secciones horizontales",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "de \[CapitalOmega] son iguales a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     RowBox[{"f", "(", "y", ")"}], "-", 
     RowBox[{"g", "(", "y", ")"}]}], "|"}], TraditionalForm]]],
 " por lo que su \[AAcute]rea viene dada por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", "y", ")"}], "-", 
      RowBox[{"g", "(", "y", ")"}]}], "|", 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Observa que esta integral expresa el \[AAcute]rea de \[CapitalOmega] como l\
\[IAcute]mite de las sumas de Riemann ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", 
       SubscriptBox["t", "k"], ")"}], "-", 
      RowBox[{"g", "(", 
       SubscriptBox["t", "k"], ")"}]}], "|", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"k", "+", "1"}]], "-", 
       SubscriptBox["y", "k"]}], ")"}]}]}], TraditionalForm]]],
 ", lo que tiene una sencilla interpretaci\[OAcute]n que puedes visualizar \
con la orden \"tipo2sup[{f,g},{y,a,b,n},opts]\" (admite opciones como \
\"Show\") que representa aproximaciones superiores al \[AAcute]rea de \
\[CapitalOmega] dividiendo el intervalo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 " ",
 StyleBox["del eje de ordenadas",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " en ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " subintervalos ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["y", "k"], ",", 
     SubscriptBox["y", 
      RowBox[{"k", "+", "1"}]]}], "]"}], TraditionalForm]]],
 " y eligiendo en cada uno de ellos el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "k"], " ", "\[Epsilon]", "  ", 
    FormBox[
     RowBox[{"[", 
      RowBox[{
       SubscriptBox["y", "k"], ",", 
       SubscriptBox["y", 
        RowBox[{"k", "+", "1"}]]}], "]"}],
     TraditionalForm], " "}], TraditionalForm]]],
 " en el que la funci\[OAcute]n",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "-", "g"}], "|"}], TraditionalForm]]],
 " alcanza su m\[AAcute]ximo absoluto en dicho subintervalo. Significado an\
\[AAcute]logo tiene el comando \"tipo1inf[{f,g},{y,a,b,n},opts]\". Prueba con \
distintas funciones. Los siguientes ejemplos son ilustrativos."
}], "Text"],

Cell[BoxData[
 RowBox[{"tipo2sup", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}], ",", "24"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.40692055646875*^9}],

Cell[BoxData[
 RowBox[{"tipo2inf", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}], ",", "24"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.406920567140625*^9}],

Cell["\<\
Las siguientes animaciones muestarn c\[OAcute]mo las aproximaciones van \
mejorando conforme aumenta el n\[UAcute]mero de intervalos de la partici\
\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"tipo2sup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", "k"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12", ",", "36", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40692057590625*^9, 3.406920577421875*^9}, {
  3.40692060953125*^9, 3.406920645234375*^9}}],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"tipo2inf", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", "k"}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12", ",", "36", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.406920673859375*^9, 3.4069206794375*^9}}],

Cell[TextData[{
 "Es importante advertir que la distinci\[OAcute]n entre regiones de tipo I y \
de tipo II es tan s\[OAcute]lo una cuesti\[OAcute]n de conveniencia. No son \
conjuntos de distinta naturaleza sino formas distintas de describir un \
conjunto. En la pr\[AAcute]tica te vas a encontrar siempre con regiones que \
puedes considerar tanto de tipo I como de tipo II y deber\[AAcute]s elegir la \
descripci\[OAcute]n que m\[AAcute]s facilite el c\[AAcute]lculo de la \
correspondiente integral. De todas formas, no debes olvidar que basta cambiar \
la variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " por la variable ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " para convertir una regi\[OAcute]n de tipo II en otra de tipo I; por tanto, \
si en un ejercicio resulta conveniente considerar la regi\[OAcute]n cuya \
\[AAcute]rea quieres calcular como una regi\[OAcute]n de tipo II y te \
encuentras m\[AAcute]s c\[OAcute]modo trabajando con regiones de tipo I, ya \
sabes lo que tienes que hacer.\nEn la pr\[AAcute]ctica, es frecuente \
describir una regi\[OAcute]n de tipo II como ",
 StyleBox["\"la regi\[OAcute]n comprendida entre las curvas",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"f", "(", "y", ")"}]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"x", "=", 
     RowBox[{"g", "(", "y", ")"}]}]}], TraditionalForm]]],
 StyleBox["\"",
  FontSlant->"Italic"],
 " sin precisar el intervalo de la variable ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 ". En estos casos, se entiende que se trata de la ",
 StyleBox["regi\[OAcute]n acotada",
  FontSlant->"Italic"],
 " comprendidad entre las dos curvas; la cual debe determinarse calculando \
los puntos de intersecci\[OAcute]n de las mismas, es decir, resolviendo la \
ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "y", ")"}], "=", 
    RowBox[{"g", "(", "y", ")"}]}], TraditionalForm]]],
 " lo que tambi\[EAcute]n nos proporciona los l\[IAcute]mites de integraci\
\[OAcute]n ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ". \n",
 StyleBox["Cuando la funci\[OAcute]n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " ", "-", " ", "g"}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" no tiene signo constante en el intervalo ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[", para calcular la integral ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", "a"], "b"], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"f", "(", "y", ")"}], "-", 
      RowBox[{"g", "(", "y", ")"}]}], "|", 
     RowBox[{"\[DifferentialD]", "y"}]}]}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" se descompone dicho  intervalo en intervalos en los que la funci\
\[OAcute]n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " ", 
    RowBox[{"-", " ", "g"}], " "}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox["es siempre positiva o siempre negativa, lo que permite quitar el \
valor absoluto en el integrando. ",
  FontWeight->"Bold"],
 "\nA veces interesa expresar una regi\[OAcute]n de tipo II como \
uni\[OAcute]n de dos o m\[AAcute]s regiones de tipo II disjuntas y \
m\[AAcute]s sencillas, entonces su \[AAcute]rea es la suma de las \
\[AAcute]reas de cada una de dichas regiones.\nAunque las regiones que hemos \
considerado antes son acotadas, la idea de regi\[OAcute]n no acotada de tipo \
I y de tipo II se entiende por s\[IAcute] sola y no precisa nueva definici\
\[OAcute]n. Los resultados anteriores se extienden f\[AAcute]cilmente al caso \
de regiones no acotadas de tipo I y de tipo II, la \[UAcute]nica diferencia \
es que ahora las \[AAcute]reas vendr\[AAcute]n dadas por integrales de \
funciones no acotadas o en intervalos no acotados. Como ya debes de saber, \
para calcular dichas integrales tienes que evaluar una primitiva y calcular \
su l\[IAcute]mite. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 3", "Subsubsection"],

Cell[TextData[{
 "Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] comprendida \
entre la par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", "x"}], TraditionalForm]]],
 " y la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"x", "-", "2"}]}], TraditionalForm]]],
 ".\nSe trata del mismo ejercicio considerado en el ejemplo 2. Recuerda que, \
para calcular el \[AAcute]rea, expres\[AAcute]bamos \[CapitalOmega] como uni\
\[OAcute]n de dos regiones de tipo I. De hecho, la propia regi\[OAcute]n \
\[CapitalOmega] es de tipo I. Sin embargo, los c\[AAcute]lculos son \
m\[AAcute]s sencillos si consideramos \[CapitalOmega] como la regi\[OAcute]n \
de tipo II limitada por las curvas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    SuperscriptBox["y", "2"]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"x", "=", 
     RowBox[{"y", "+", "2"}]}]}], TraditionalForm]]],
 " cuyos puntos de intersecci\[OAcute]n se obtiene para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "2"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{"tipo2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["y", "2"], ",", 
     RowBox[{"y", "+", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40692070715625*^9, 3.40692071971875*^9}}],

Cell[TextData[{
 "Por tanto, el \[AAcute]rea de \[CapitalOmega] viene dada por ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "1"}], "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "+", "2", "-", 
        SuperscriptBox["y", "2"]}], ")"}], 
      RowBox[{"\[DifferentialD]", "y"}]}]}]}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"y", "+", "2", "-", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Si quieres ver \[CapitalOmega] como una regi\[OAcute]n de tipo I m\[AAcute]s \
sencilla que la considerada en el ejemplo 2, puedes simetrizar su \
gr\[AAcute]fica como sigue. \
\>", "Text"],

Cell[BoxData[
 RowBox[{"tipo1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{"x", "+", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.406920740625*^9, 3.40692075596875*^9}}],

Cell[TextData[{
 "Aunque la regi\[OAcute]n as\[IAcute] obtenida no es la misma \
\[CapitalOmega] tiene, sin embargo, igual \[AAcute]rea que \[CapitalOmega]  \
pues ambas regiones se transforman una en otra por medio de una simetr\
\[IAcute]a respecto de la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "x"}], TraditionalForm]]],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
 StyleBox["1",
  FontWeight->"Bold"],
 " Calcula las \[AAcute]reas de las regiones del plano limitadas por las \
siguientes curvas.\n",
 StyleBox["a)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{"12", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"12", 
      SuperscriptBox["y", "3"]}]}]}], TraditionalForm]]],
 "  y  ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"2", "y"}]}]}]}], TraditionalForm]]],
 ".\n",
 StyleBox["b)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"2", "x"}]}]}], TraditionalForm]]],
 "  e  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "4"}]}], TraditionalForm]]],
 ", para  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "3"}], "\[LessEqual]", "  ", "x", "\[LessEqual]", " ", "1"}],
    TraditionalForm]]],
 ".\n",
 StyleBox["c)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]]],
 "  y   ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", "y"}], "=", "2"}], TraditionalForm]]],
 ", con ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", " ", "0"}], ",", " ", 
    RowBox[{"y", "\[GreaterEqual]", " ", "0"}]}], TraditionalForm]]],
 ".\n",
 StyleBox["d)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     SuperscriptBox["y", "2"]}], "=", "3"}], TraditionalForm]]],
 "  y  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"4", "x"}], "+", 
     SuperscriptBox["y", "2"]}], "=", "4"}], TraditionalForm]]],
 ".\n",
 StyleBox["e)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "=", 
     RowBox[{
      SuperscriptBox["sec", "2"], "x"}]}], ",", "  ", 
    RowBox[{"y", "=", 
     RowBox[{
      SuperscriptBox["tg", "2"], "x"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Pi]"}], "/", "4"}], "\[LessEqual]", " ", "x", 
     "\[LessEqual]", " ", 
     RowBox[{"\[Pi]", "/", "4"}]}]}], TraditionalForm]]],
 ".\n",
 StyleBox["f)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "2"], "4"], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "9"]}],
     FontSize->18], "=", "1"}], TraditionalForm]]],
 ".\n",
 StyleBox["g)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "x"}], ")"}], "2"], "=", 
    RowBox[{"x", "-", "3"}]}], TraditionalForm]]],
 ",  y  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "7"}], TraditionalForm]]],
 ".\n",
 StyleBox["h)  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"16", "x"}], "-", "4"}]}], TraditionalForm]]],
 "  y  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     RowBox[{"6", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"8", "x"}], "-", "4"}]}], TraditionalForm]]],
 ". \n",
 StyleBox["i)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    StyleBox[
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["x", "3"]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "4"], "-", " ", 
        SuperscriptBox["x", "2"], "+", "1"}]]],
     FontSize->18]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    StyleBox[
     FractionBox[
      RowBox[{"2", " ", "x"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "4"], "-", 
        SuperscriptBox["x", "2"], "+", "1"}]]],
     FontSize->18]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", " ", "x", "\[LessEqual]", " ", "1"}], 
   TraditionalForm]]],
 ".\n",
 StyleBox["j)  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"log", " ", "x"}], ")"}], "2"]}], ",", " ", 
    RowBox[{"0", "<", " ", "x", "\[LessEqual]", " ", "e"}]}], 
   TraditionalForm]]],
 ".\n",
 StyleBox["k)",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", 
    StyleBox[
     FractionBox[
      RowBox[{"1", "-", " ", "x"}], 
      RowBox[{"1", "+", " ", "x"}]],
     FontSize->18]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]]],
 ".\n",
 StyleBox["l)",
  FontWeight->"Bold"],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"x", " ", 
     SuperscriptBox["e", 
      RowBox[{"-", "x"}]]}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "2"], 
     SuperscriptBox["e", 
      RowBox[{"-", "x"}]]}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[GreaterEqual]", " ", "0"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[TextData[{
 StyleBox["2",
  FontWeight->"Bold"],
 " Calcula el \[AAcute]rea de la regi\[OAcute]n limitada por la astroide ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RadicalBox[
      SuperscriptBox["x", "2"], "3"], "+", 
     RadicalBox[
      SuperscriptBox["y", "2"], "3"]}], "=", "1"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tipo1", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RadicalBox[
           SuperscriptBox["x", "2"], "3"]}], ")"}], "3"]], ",", 
      RowBox[{"-", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RadicalBox[
            SuperscriptBox["x", "2"], "3"]}], ")"}], "3"]]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"representa", " ", "la", " ", "astroide"}], " ", "*)"}]}]], "Input",\

 CellChangeTimes->{{3.406920827296875*^9, 3.406920828875*^9}}],

Cell[TextData[{
 StyleBox["3",
  FontWeight->"Bold"],
 " Calcula el \[AAcute]rea de la regi\[OAcute]n comprendida entre la cisoide \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", 
    StyleBox[
     FractionBox[
      SuperscriptBox["x", "3"], 
      RowBox[{"2", " ", "-", " ", "x"}]],
     FontSize->18]}], TraditionalForm]]],
 " y su as\[IAcute]ntota ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "2."}], TraditionalForm]]]
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tipo1", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox[
       FractionBox[
        SuperscriptBox["x", "3"], 
        RowBox[{"2", "-", "x"}]]], ",", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox[
         SuperscriptBox["x", "3"], 
         RowBox[{"2", "-", "x"}]]]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1.3"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"representa", " ", "parte", " ", "de", " ", "la", " ", "cisoide"}],
    " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.4069208378125*^9, 3.406920839234375*^9}}],

Cell[TextData[{
 StyleBox["4",
  FontWeight->"Bold"],
 " Calcula el \[AAcute]rea de las dos partes en que la par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", "x"}], TraditionalForm]]],
 " divide al c\[IAcute]rculo ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", "8"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"y", "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "==", 
       SqrtBox[
        RowBox[{"8", "-", 
         SuperscriptBox["y", "2"]}]]}], ",", "y"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"tipo2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["y", "2"], ",", 
     SqrtBox[
      RowBox[{"8", "-", 
       SuperscriptBox["y", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], "\n", 
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.406920845765625*^9, 3.4069208685*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Curvas definidas por ecuaciones param\[EAcute]tricas\
\>", "Section"],

Cell[TextData[{
 "Seguramente te imaginas una curva en el plano como una l\[IAcute]nea \
continua que puede dibujarse de un trazo, sin levantar el l\[AAcute]piz del \
papel. Esa idea es esencialmente correcta. Las circunferencias, las elipses, \
las astroides son todas ellas curvas. Faltar\[IAcute]a m\[AAcute]s. Ninguna \
de ellas puedes representarla por una igualdad de la forma ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 ". Las curvas que pueden representarse por una ecuaci\[OAcute]n cartesiana \
del tipo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " son curvas muy particulares pues son gr\[AAcute]ficas de funciones. No \
olvides que cuando dices \"sea la curva dada por la ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 "\"  te est\[AAcute]s refiriendo a la curva cuya imagen es el conjunto de \
puntos del plano ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], ":", 
      RowBox[{"x", " ", 
       RowBox[{"\[Epsilon]", " ", "[", 
        RowBox[{"a", ",", "b"}], "]"}]}]}], ",", " ", 
     RowBox[{"y", "=", 
      RowBox[{"f", "(", "x", ")"}]}]}], "}"}], TraditionalForm]]],
 ", es decir, a la gr\[AAcute]fica de ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 ". Si lo piensas un momento ver\[AAcute]s que muy pocas curvas son gr\
\[AAcute]ficas. Para que una curva sea una gr\[AAcute]fica es necesario que \
cualquier recta vertical la corte a lo m\[AAcute]s en un solo punto; ninguna \
curva cerrada cumple esta condici\[OAcute]n. Precisamente entre las curvas \
cerradas se encuentran algunas de las curvas m\[AAcute]s intersantes, a ellas \
pertenecen los distintos tipos de \[OAcute]valos y lemniscatas, las \
cardioides, y muchas m\[AAcute]s. Vamos a ver ahora una forma de representar \
curvas planas mucho m\[AAcute]s general que las ecuaciones cartesianas del \
tipo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " que s\[OAcute]lo sirven para representar curvas que tambi\[EAcute]n son gr\
\[AAcute]ficas.\nPara empezar, consideremos una curva que viene dada por una \
ecuaci\[OAcute]n cartesiana de la forma ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " donde ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LessEqual]", " ", "x", "\[LessEqual]", " ", "y"}], 
   TraditionalForm]]],
 ". Nuestra curva es, por tanto, la imagen de la aplicaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], " ", "\[Rule]", " ", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "2"]}], TraditionalForm]]],
 " definida por ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", "(", "x", ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"x", ",", 
      RowBox[{"f", "(", "x", ")"}]}], ")"}]}], TraditionalForm]]],
 " para todo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], TraditionalForm]]],
 ". Intuitavamente, cuando  ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 "  recorre el intervalo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 ", el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", 
     RowBox[{"f", "(", "x", ")"}]}], ")"}], TraditionalForm]]],
 " recorre la curva. Es f\[AAcute]cil generalizar esta situaci\[OAcute]n sin \
perder la idea intuitiva de curva. Lo esencial es que podamos describir las \
coordendas de los puntos de la curva como funciones continuas de un par\
\[AAcute]metro. En la situaci\[OAcute]n que estamos considerando se tiene que \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " ,es decir, la segunda coordenada es funci\[OAcute]n continua de la \
primera. La generalizaci\[OAcute]n consiste en que ambas coordenadas sean \
funciones continuas de un par\[AAcute]metro. Llegamos as\[IAcute] a la \
definici\[OAcute]n siguiente.\n",
 StyleBox["Definici\[OAcute]n",
  FontWeight->"Bold"],
 ". Una curva en el plano es una aplicaci\[OAcute]n continua ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], " ", "\[Rule]", " ", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "2"]}], TraditionalForm]]],
 ". Si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", "(", "t", ")"}], "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "(", "t", ")"}], ",", 
      RowBox[{"y", "(", "t", ")"}]}], ")"}]}], TraditionalForm]]],
 " decimos que ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"{", GridBox[{
       {
        RowBox[{"x", "=", 
         RowBox[{"x", "(", "t", ")"}]}]},
       {
        RowBox[{"y", "=", 
         RowBox[{"y", "(", "t", ")"}]}]}
      }]}]}], TraditionalForm]]],
 "  son las ",
 StyleBox["ecuaciones par\[AAcute]metricas",
  FontWeight->"Bold"],
 " de la curva. El punto \[Gamma](a) es el origen y \[Gamma](b) el extremo de \
la curva. Si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", "(", "a", ")"}], "=", 
    RowBox[{"\[Gamma]", "(", "b", ")"}]}], TraditionalForm]]],
 " se dice que la curva es ",
 StyleBox["cerrada",
  FontWeight->"Bold"],
 ". Se dice que una curva \[Gamma] es ",
 StyleBox["simple",
  FontWeight->"Bold"],
 " si no se corta a s\[IAcute] misma, es decir, si para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", ",", 
    RowBox[{"t", " ", 
     RowBox[{"\[Epsilon]", " ", "[", 
      RowBox[{"a", ",", "b"}], "]"}], " "}]}], TraditionalForm]]],
 "con  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[NotEqual]", "s"}], TraditionalForm]]],
 "  se verifica que  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", "(", "t", ")"}], "\[NotEqual]", 
    RowBox[{"\[Gamma]", "(", "s", ")"}]}], TraditionalForm]]],
 ". Una curva cerrada se llama simple si la funci\[OAcute]n \[Gamma] es \
inyectiva en ]a,b[."
}], "Text"],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"\[Alpha]", "+", 
        RowBox[{"a", " ", "cos", " ", "t"}]}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"\[Beta]", "+", 
        RowBox[{"b", " ", "sen", " ", "t"}]}]}]}],
     FontWeight->"Bold"]}], TraditionalForm]]],
 " para ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", " ", 
     RowBox[{"2", "\[Pi]"}]}], ",", " ", 
    RowBox[{"\[Alpha]", ">", "0"}], ",", 
    RowBox[{"\[Beta]", ">", "0"}]}], TraditionalForm]]],
 " es una ",
 StyleBox["elipse",
  FontWeight->"Bold"],
 " de centro ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], ")"}], TraditionalForm]]],
 " y semiejes de longitudes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ",", " ", "b"}], TraditionalForm]]],
 ". Cuando ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "b"}], TraditionalForm]]],
 " se trata de una c\[IAcute]rcunferencia."
}], "Text"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"3", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"2", 
       RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.40692089575*^9}],

Cell[TextData[{
 "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{"t", "-", 
        RowBox[{"sen", " ", "t"}]}], ")"}]}]}], ",", " ", 
    RowBox[{"y", "=", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", " ", 
        RowBox[{"cos", " ", "t"}]}], ")"}]}]}]}], TraditionalForm]]],
 " para ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", " ", 
      RowBox[{"2", "\[Pi]"}]}],
     TraditionalForm], " "}], TraditionalForm]]],
 "es la ",
 StyleBox["cicloide",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". Es la curva que describir\[IAcute]a una chincheta clavada en una rueda de \
radio ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]]],
 " que avanza girando sin deslizar. "
}], "Text"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "-", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Pi]", ",", 
        RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{3.40692090746875*^9}],

Cell["\<\
Para ver c\[OAcute]mo se genera la cicloide ejecuta la siguiente celda\
\>", "Text"],

Cell[BoxData["cicloide"], "Input",
 CellChangeTimes->{{3.406920923625*^9, 3.406920927828125*^9}}],

Cell[TextData[{
 "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"cos", " ", "t", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"cos", " ", "t"}]}], ")"}]}]}], ",", " ", 
    RowBox[{"y", "=", 
     RowBox[{"sen", " ", "t", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"cos", " ", "t"}]}], ")"}]}]}]}], TraditionalForm]]],
 " para ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", " ", 
      RowBox[{"2", "\[Pi]"}]}],
     TraditionalForm], " "}], TraditionalForm]]],
 "es una ",
 StyleBox["cardioide",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". Es la curva que describe un punto fijo del borde de un c\[IAcute]rculo \
que rueda sin deslizar sobre otro del mismo radio. "
}], "Text"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], "+", "1"}], ")"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], "+", "1"}], ")"}], " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{3.406920953*^9}],

Cell[TextData[{
 "La ecuaci\[OAcute]n cartesiana de la cardioide es ",
 Cell[BoxData[
  FormBox[
   FormBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "x"}], "+", 
        SuperscriptBox["y", "2"]}], ")"}], "2"], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}], " ", "4", " ", 
      SuperscriptBox["a", "2"]}]}],
    TraditionalForm], TraditionalForm]]],
 " donde ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " es un par\[AAcute]metro positivo. Para ver c\[OAcute]mo se genera la \
cardiode ejecuta la siguiente celda"
}], "Text"],

Cell[BoxData["cardioide"], "Input",
 CellChangeTimes->{3.40692096734375*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[FilledSmallCircle]", "  ", "La", " ", 
     StyleBox["lemniscata",
      FontWeight->"Bold",
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontWeight->"Bold",
      FontSlant->"Italic"], 
     StyleBox["de",
      FontWeight->"Bold",
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontWeight->"Bold",
      FontSlant->"Italic"], 
     StyleBox["Bernouilli",
      FontWeight->"Bold",
      FontSlant->"Italic"], " ", "es", " ", "la", " ", "curva", " ", "de", 
     " ", "ecuaciones", " ", "param\[EAcute]tricas", 
     StyleBox["  ",
      FontFamily->"Times New Roman",
      FontSize->13], 
     StyleBox["x",
      FontFamily->"Times New Roman"], 
     StyleBox[
      RowBox[{"(", "t", ")"}],
      FontFamily->"Times New Roman"]}], 
    StyleBox["=",
     FontFamily->"Times New Roman"], 
    StyleBox[
     FractionBox[
      RowBox[{"cos", 
       RowBox[{"(", "t", ")"}]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["sen", "2"], 
        RowBox[{"(", "t", ")"}]}], "+", "1"}]],
     FontFamily->"Times New Roman"]}], 
   StyleBox[" ",
    FontFamily->"Times New Roman"], 
   StyleBox[",",
    FontFamily->"Times New Roman"], 
   StyleBox[" ",
    FontFamily->"Times New Roman"], 
   RowBox[{
    StyleBox[
     RowBox[{"y", 
      RowBox[{"(", "t", ")"}]}],
     FontFamily->"Times New Roman"], 
    StyleBox["=",
     FontFamily->"Times New Roman"], 
    RowBox[{
     StyleBox[
      FractionBox[
       RowBox[{"cos", 
        RowBox[{"(", "t", ")"}], "sen", 
        RowBox[{"(", "t", ")"}]}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["sen", "2"], 
         RowBox[{"(", "t", ")"}]}], "+", "1"}]],
      FontFamily->"Times New Roman"], " ", "para", 
     RowBox[{
      FormBox[
       RowBox[{" ", 
        FormBox[
         RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", " ", 
          RowBox[{"2", "\[Pi]"}]}],
         TraditionalForm], " "}],
       TraditionalForm], "."}]}]}]}], TextForm]], "Text"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", "t", "]"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", "t", "]"}], "2"], "+", "1"}]], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", "t", "]"}], "2"], "+", "1"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"417", ",", "147.375"}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40692109059375*^9, 3.406921129921875*^9}}],

Cell[TextData[{
 "La ecuaci\[OAcute]n cartesiana de la lemniscata es  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}], "2"], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}]}], TraditionalForm]]],
 " y se define como el lugar geom\[EAcute]trico de los puntos del plano cuyo \
producto de distancias a dos puntos fijos es constante igual al cuadrado de \
la semidistancia entre dichos puntos. Observa que, a diferencia de las \
anteriores, la lemniscata no es una curva simple."
}], "Text"],

Cell["\<\
\[FilledSmallCircle]  Aqu\[IAcute] tienes otro ejemplo de una curva que no es \
simple. \
\>", "Text"],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"3", "x"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", ".008", "]"}], ",", 
      RowBox[{"Hue", "[", ".65", "]"}]}], "}"}]}], ",", 
   RowBox[{"Ticks", "->", "None"}]}], "]"}]], "Input",
 CellChangeTimes->{3.406921140046875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox["C\[AAcute]lculo del \[AAcute]rea de una regi\[OAcute]n plana \
rodeada por una curva definida por ecuaciones param\[EAcute]tricas",
  FontSize->16]
}], "Subsubsection",
 FontSize->12],

Cell[TextData[{
 "Sea \[CapitalOmega] la regi\[OAcute]n rodeada por una curva ",
 StyleBox["cerrada simple",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Gamma]", "(", "t", ")"}], "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "(", "t", ")"}], ",", 
       RowBox[{"y", "(", "t", ")"}]}], ")"}]}], ",", " ", 
    RowBox[{"(", 
     RowBox[{"a", "\[LessEqual]", "t", "\[LessEqual]", "b"}], ")"}]}], 
   TraditionalForm]]],
 " y supongamos que las funciones ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", "\[RightArrow]", " ", 
     RowBox[{"x", "(", "t", ")"}]}], ",", " ", 
    RowBox[{"t", "\[RightArrow]", " ", 
     RowBox[{"y", "(", "t", ")"}]}]}], TraditionalForm]]],
 " tienen primera derivada continua. Supongamos tambi\[EAcute]n que si, a \
medida que el par\[AAcute]metro ",
 StyleBox["t",
  FontSlant->"Italic"],
 " recorre el intervalo desde",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"t", "=", "a"}]}], TraditionalForm]]],
 " hasta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "b"}], TraditionalForm]]],
 ", andamos sobre la curva siguiendo al punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "(", "t", ")"}], TraditionalForm]]],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["la regi\[OAcute]n \[CapitalOmega] queda a nuestar izquierda",
  FontWeight->"Bold"],
 ". En estas condiciones se verifica que el \[AAcute]rea de \[CapitalOmega] \
viene dada por:"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{"  ", 
   RowBox[{
    FormBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
       RowBox[{
        RowBox[{
         StyleBox[
          SubsuperscriptBox["\[Integral]", "a", "b"],
          FontSize->16], 
         RowBox[{
          RowBox[{
           StyleBox["x",
            FontSize->16], "(", "t", ")"}], 
          RowBox[{"y", "'"}], 
          RowBox[{"(", "t", ")"}], 
          RowBox[{"\[DifferentialD]", "t"}]}]}], " ", "=", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           StyleBox[
            SubsuperscriptBox["\[Integral]", "a", "b"],
            FontSize->16], 
           RowBox[{
            RowBox[{
             StyleBox["y",
              FontSize->16], "(", "t", ")"}], 
            RowBox[{"x", "'"}], 
            RowBox[{"(", "t", ")"}], 
            RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
         FractionBox["1", "2"]}]}]}], " "}],
     TraditionalForm], 
    RowBox[{
     StyleBox[
      SubsuperscriptBox["\[Integral]", "a", "b"],
      FontSize->16], 
     RowBox[{
      RowBox[{
       StyleBox["(",
        FontSize->16], 
       RowBox[{
        RowBox[{
         RowBox[{
          StyleBox["x",
           FontSize->16], "(", "t", ")"}], 
         RowBox[{"y", "'"}], 
         RowBox[{"(", "t", ")"}]}], "-", " ", 
        RowBox[{
         RowBox[{"y", "(", "t", ")"}], 
         RowBox[{"x", "'"}], 
         RowBox[{"(", "t", ")"}]}]}], 
       StyleBox[")",
        FontSize->14]}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "La igualdad entre las dos integrales se deduce f\[AAcute]cilmente \
integrando por partes y teniendo en cuenta que por ser ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " una curva cerrada se tiene que  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "(", "b", ")"}], 
      RowBox[{"y", "(", "b", ")"}]}], "-", 
     RowBox[{
      RowBox[{"x", "(", "a", ")"}], 
      RowBox[{"y", "(", "a", ")"}]}]}], "=", "0"}], TraditionalForm]]],
 ". Si el sentido de recorrido de la curva es el opuesto al anterior de forma \
que al recorrerla la regi\[OAcute]n \[CapitalOmega] queda a la derecha \
debemos cambiar el signo en las integrales anteriores."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[BoxData[
 FormBox[
  RowBox[{"\[FilledSmallCircle]", 
   StyleBox["  ",
    FontWeight->"Plain"], 
   StyleBox["\[CapitalAAcute]rea",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["de",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["la",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["regi\[OAcute]n",
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontWeight->"Plain"], 
   StyleBox["\[CapitalOmega]",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["encerrada",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["por",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["la",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   StyleBox["elipse",
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain"], 
   FormBox[
    RowBox[{" ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "(", "t", ")"}], "=", 
       RowBox[{"\[Alpha]", " ", "+", 
        RowBox[{"a", " ", "cos", " ", "t"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "(", "t", ")"}], "=", 
       RowBox[{"\[Beta]", "+", " ", 
        RowBox[{"b", " ", "sen", " ", "t"}]}]}]}]}],
    TraditionalForm], 
   StyleBox["  ",
    FontWeight->"Plain"], 
   RowBox[{
    FormBox[
     StyleBox[
      RowBox[{"(", 
       RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
        RowBox[{"2", "\[Pi]"}]}], ")"}],
      FontWeight->"Plain"],
     TraditionalForm], "."}]}], TextForm]], "Text"],

Cell["\<\
 Observa que al recorrer la curva la regi\[OAcute]n \[CapitalOmega] queda a \
la izquierda por lo que el \[AAcute]rea viene dada por:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "t_", "]"}], "=", 
   RowBox[{"\[Alpha]", "+", 
    RowBox[{"a", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], "=", 
   RowBox[{"\[Beta]", " ", "+", " ", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "t", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], 
    RowBox[{
     RowBox[{"y", "'"}], "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "Input"],

Cell[TextData[{
 "\[FilledSmallCircle]",
 StyleBox["  Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] \
encerrada por un arco de la cicloide  ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"  ", 
    FormBox[
     RowBox[{
      RowBox[{
       RowBox[{"x", "(", "t", ")"}], "=", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{"t", "-", 
          RowBox[{"sen", " ", "t"}]}], ")"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "(", "t", ")"}], "=", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", " ", 
          RowBox[{"cos", " ", "t"}]}], ")"}]}]}]}],
     TraditionalForm]}], TraditionalForm]],
  FontWeight->"Plain"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"2", "\[Pi]"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[", y el segmento que va de ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "r"}], ",", "0"}], ")"}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" a (0,0). Dicho segmento tiene como ecuaciones parametricas ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"u", "(", "t", ")"}], ",", 
       RowBox[{"v", "(", "t", ")"}]}], ")"}], "=", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "r"}], " ", "t"}], " ", "+", 
        RowBox[{"4", "\[Pi]", " ", "r"}]}], ",", "0"}], ")"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["donde ",
  FontWeight->"Plain"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"2", "\[Pi]"}], "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"4", "\[Pi]"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 ". "
}], "Text",
 FontWeight->"Bold"],

Cell[TextData[StyleBox["Observa que al recorrer la curva la regi\[OAcute]n \
\[CapitalOmega] queda a la derecha por lo que el \[AAcute]rea viene dada \
por:",
 FontWeight->"Plain"]], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "t_", "]"}], "=", 
   RowBox[{"r", 
    RowBox[{"(", 
     RowBox[{"t", "-", 
      RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], "=", 
   RowBox[{"r", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", " ", "r"}], " ", "t"}], "+", 
    RowBox[{"4", " ", "Pi", " ", "r"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "t_", "]"}], "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "-", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t", "]"}], 
     RowBox[{
      RowBox[{"v", "'"}], "[", "t", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"2", "Pi"}], ",", 
      RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
 "5",
 StyleBox[" Calcular el \[AAcute]rea encerrada por la cardioide  ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{"x", "=", 
      RowBox[{"cos", " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"cos", " ", "t"}]}], ")"}]}]}],
     FontWeight->"Plain"], 
    StyleBox[",",
     FontWeight->"Plain"], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    RowBox[{
     StyleBox["y",
      FontWeight->"Plain"], 
     StyleBox["=",
      FontWeight->"Plain"], 
     RowBox[{
      StyleBox["sen",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["t",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      RowBox[{"(", 
       StyleBox[
        RowBox[{"1", "+", 
         RowBox[{"cos", " ", "t"}]}],
        FontWeight->"Plain"], 
       StyleBox[")",
        FontWeight->"Plain"]}]}]}], 
    StyleBox[",",
     FontWeight->"Plain"], 
    StyleBox[
     RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", " ", 
      RowBox[{"2", "\[Pi]"}]}],
     FontWeight->"Plain"]}], TraditionalForm]]],
 ". "
}], "Text",
 FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalAAcute]reas planas en coordenadas polares \
\>", "Section"],

Cell[TextData[{
 "Dado un punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], " ", "\[Epsilon]", " ", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "2"]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}], "\[NotEqual]", " ", 
     RowBox[{"(", 
      RowBox[{"0", ",", "0"}], ")"}]}], ","}], TraditionalForm]]],
 " hay un \[UAcute]nico par de n\[UAcute]meros ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[Rho]", ",", "\[Theta]"}], ")"}], TraditionalForm]]],
 " tales que ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", "\[Rho]"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
   TraditionalForm]]],
 " y que verifican las igualdades ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"{", GridBox[{
       {
        RowBox[{"x", "=", 
         RowBox[{"\[Rho]", " ", "cos", " ", "\[Theta]"}]}]},
       {
        RowBox[{"y", "=", " ", 
         RowBox[{"\[Rho]", " ", "sen", " ", "\[Theta]"}]}]}
      }]}],
    #& ], TraditionalForm]]],
 ". Dichos n\[UAcute]meros se llaman ",
 StyleBox["coordenadas polares",
  FontSlant->"Italic"],
 " del punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " y vienen dados por ",
 Cell[BoxData[
  FormBox[
   TagBox["",
    #& ], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]]}], TraditionalForm]]],
 ";  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{"arctg", 
     StyleBox[
      FractionBox["y", 
       RowBox[{"x", " "}]],
      FontSize->18]}]}], TraditionalForm]]],
 "si ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]]],
 ";",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"\[Theta]", "=", 
     FormBox[
      RowBox[{
       RowBox[{"arctg", 
        StyleBox[
         FractionBox["y", 
          RowBox[{"x", " "}]],
         FontSize->18]}], 
       StyleBox["-",
        FontSize->18], 
       StyleBox["\[Pi]",
        FontSize->14]}],
      TraditionalForm]}]}], TraditionalForm]]],
 " si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", " ", 
    RowBox[{"y", "<", "0"}]}], TraditionalForm]]],
 "; ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    FormBox[
     RowBox[{
      RowBox[{"arctg", 
       StyleBox[
        FractionBox["y", 
         RowBox[{"x", " "}]],
        FontSize->18]}], "+", 
      StyleBox["\[Pi]",
       FontSize->14]}],
     TraditionalForm]}], TraditionalForm]]],
 " si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", " ", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], TraditionalForm]]],
 "; ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{"\[Pi]", "/", "2"}]}], TraditionalForm]]],
 " si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", "0"}], ",", " ", 
    RowBox[{"y", ">", "0"}]}], TraditionalForm]]],
 "; ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "/", "2"}]}], TraditionalForm]]],
 " si ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", "0"}], ",", " ", 
    RowBox[{"y", "<", "0"}]}], TraditionalForm]]],
 ". El n\[UAcute]mero \[Theta] se llama ",
 StyleBox["\[AAcute]ngulo polar",
  FontSlant->"Italic"],
 " del vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " y el n\[UAcute]mero \[Rho] es la norma eucl\[IAcute]dea de dicho vector. \
La funci\[OAcute]n \"polares[{x,y}]\" proporciona las coordenadas polares del \
punto de coordenadas cartesianas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 ". La funci\[OAcute]n \"cartesianas[{\[Rho],\[Theta]}]\" proporciona las \
coordenadas cartesianas del punto de coordenadas polares ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[Rho]", ",", "\[Theta]"}], ")"}], TraditionalForm]]],
 ".  Practica un poco con estos comandos y observa c\[OAcute]mo la funci\
\[OAcute]n \"ArcTan[x,y]\" tiene en cuenta el cuadrante donde est\[AAcute] el \
punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"polares", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]], ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cartesianas", "[", 
    RowBox[{"{", 
     RowBox[{"\[Rho]_", ",", "\[Theta]_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "Es importante advertir que en la definici\[OAcute]n anterior el intervalo \
]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], TraditionalForm]]],
 "]  se puede sustituir por cualquier intervalo ",
 StyleBox["semiabierto",
  FontSlant->"Italic"],
 " ",
 StyleBox["I",
  FontSlant->"Italic"],
 " de longitud 2\[Pi] lo que, naturalmente, implica modificar la definici\
\[OAcute]n de \[Theta] sumando o restando, seg\[UAcute]n proceda, un m\
\[UAcute]ltiplo conveniente de 2\[Pi] de manera que el \[AAcute]ngulo polar \
est\[EAcute] en dicho intervalo ",
 StyleBox["I",
  FontSlant->"Italic"],
 ". Es frecuente considerar valores del \[AAcute]ngulo polar en el intervalo \
[",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", 
    RowBox[{"2", "\[Pi]"}]}], TraditionalForm]]],
 "[.  Salvo que se especifique otra cosa, entenderemos que el \[AAcute]ngulo \
polar est\[AAcute] en el intervalo  ]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], TraditionalForm]]],
 "].\nLa funci\[OAcute]n \"PolarPlot[f[\[Theta]],{\[Theta], \[Alpha], \
\[Beta]}]\" representa la curva cuya ecuaci\[OAcute]n en coordenadas polares \
es ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "=", 
     RowBox[{"f", "(", "\[Theta]", ")"}]}], ",", "  ", 
    RowBox[{"(", 
     RowBox[{
     "\[Alpha]", "\[LessEqual]", "\[Theta]", "\[LessEqual]", "\[Beta]"}], 
     ")"}]}], TraditionalForm]]],
 ". Es decir, representa el conjunto de puntos del plano cuyas coordenadas \
polares son  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "(", "\[Theta]", ")"}], ",", "\[Theta]"}], ")"}], 
   TraditionalForm]]],
 " cuando ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]}], TraditionalForm]]],
 ". Equivalentemente, ",
 StyleBox["se trata de la curva cuyas ecuaciones param\[EAcute]tricas son",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", "(", "\[Theta]", ")"}], "=", 
     RowBox[{
      RowBox[{"f", "(", "\[Theta]", ")"}], 
      RowBox[{"cos", "(", "\[Theta]", ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"y", "(", "\[Theta]", ")"}], "=", 
     RowBox[{
      RowBox[{"f", "(", "\[Theta]", ")"}], "sen", " ", 
      RowBox[{"(", "\[Theta]", ")"}]}]}]}], TraditionalForm]]],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolarPlot", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"la", " ", "cardioide"}], ",", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "x", "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"], "-", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}]}], "=", "0"}], ",", " ", 
    RowBox[{
     RowBox[{
     "cuya", " ", "ecuaci\[OAcute]n", " ", "en", " ", "coordenadas", " ", 
      "polares", " ", "es", " ", "\[Rho]"}], "=", 
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{3.406921274859375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "\[Theta]"}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "4"}], ",", 
       RowBox[{"\[Pi]", "/", "4"}]}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"la", " ", 
     StyleBox["mitad",
      FontSlant->"Italic"], " ", "de", " ", "la", " ", "lemniscata"}], ",", 
    " ", 
    RowBox[{
     FormBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], "2"], "-", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}],
      TraditionalForm], "=", "0"}], ",", " ", 
    RowBox[{
     RowBox[{
     "cuya", " ", "ecuaci\[OAcute]n", " ", "en", " ", "coordenadas", " ", 
      "polares", " ", "es", " ", 
      SuperscriptBox["\[Rho]", "2"]}], "=", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", "\[Theta]"}], "]"}]}]}], " ", "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolarPlot", "[", 
   RowBox[{"\[Theta]", ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", 
      RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "las", " ", "dos", " ", "primeros", " ", "vueltas", " ", "de", " ", "la", 
     " ", "espiral", " ", "de", " ", "Arqu\[IAcute]mides", " ", "cuya", " ", 
     "ecuaci\[OAcute]n", " ", "en", " ", "coordenadas", " ", "polares", " ", 
     "es", " ", "\[Rho]"}], "=", "\[Theta]"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.406921289921875*^9, 3.406921291171875*^9}}],

Cell[TextData[{
 "Supongamos que queremos calcular el \[AAcute]rea de la regi\[OAcute]n del \
plano ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Rho]", " ", "cos", " ", "\[Theta]"}], ",", 
         RowBox[{"\[Rho]", " ", "sen", " ", "\[Theta]"}]}], ")"}], ":", " ", 
       RowBox[{"0", "\[LessEqual]", "\[Rho]", "\[LessEqual]", 
        RowBox[{"f", "(", "\[Theta]", ")"}]}]}], ",", " ", 
      RowBox[{
      "\[Alpha]", "\[LessEqual]", "\[Theta]", "\[LessEqual]", "\[Beta]"}]}], 
     "}"}]}], TraditionalForm]]],
 ". Se trata de la regi\[OAcute]n limitada por la gr\[AAcute]fica de la curva \
dada en coordenadas polares por la ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", 
    RowBox[{"f", "(", "\[Theta]", ")"}]}], TraditionalForm]]],
 ", donde ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ":", 
    RowBox[{
     RowBox[{"[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "\[LongRightArrow]", 
     "\[DoubleStruckCapitalR]"}]}], TraditionalForm]]],
 " es una funci\[OAcute]n continua, y las rectas cuya ecuaci\[OAcute]n en \
coordendas polares son ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Theta]", "=", "\[Alpha]"}], ",", " ", 
    RowBox[{"\[Theta]", "=", "\[Beta]"}]}], TraditionalForm]]],
 ". F\[IAcute]jate en la figura. "
}], "Text"],

Cell[BoxData["fig"], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.4069213080625*^9}],

Cell[TextData[{
 "Lo que hacemos para calcular el \[AAcute]rea es aproximar \[CapitalOmega] \
por medio de sectores circulares. Recuerda que el \[AAcute]rea de un sector \
circular de radio \[Rho] y amplitud \[CurlyPhi] (medida en radianes) es igual \
a ",
 Cell[BoxData[
  RowBox[{
   FormBox[
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["\[Rho]", "2"], 
     RowBox[{"\[CurlyPhi]", "."}]}],
    TraditionalForm], " "}]]],
 "Consideramos para ello una partici\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Alpha]", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "<", 
         SubscriptBox["\[Theta]", "1"], "<", 
         SubscriptBox["\[Theta]", "2"], "<"}], " ", "..."}], " ", "<", 
       SubscriptBox["\[Theta]", 
        RowBox[{"n", "-", "1"}]], "<", 
       SubscriptBox["\[Theta]", "n"]}], "=", "\[Beta]"}]}],
    FontSize->12], TraditionalForm]],
  FontSize->16],
 " de",
 StyleBox[" ",
  FontSize->16],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}],
    FontSize->12], TraditionalForm]],
  FontSize->16],
 " y formamos la suma ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"f", "(", 
        SubscriptBox["\[Theta]", "k"], ")"}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Theta]", "k"], "-", 
       SubscriptBox["\[Theta]", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 ". Como el n\[UAcute]mero ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"f", "(", 
       SubscriptBox["\[Theta]", "k"], ")"}], ")"}], "2"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Theta]", "k"], "-", 
      SubscriptBox["\[Theta]", 
       RowBox[{"k", "-", "1"}]]}], ")"}]}], TraditionalForm]]],
 " es el \[AAcute]rea del sector circular, representado en azul en la figura, \
de radio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["\[Theta]", "k"], ")"}], " "}], TraditionalForm]]],
 "y amplitud  igual a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Theta]", "k"], "-", 
    SubscriptBox["\[Theta]", 
     RowBox[{"k", "-", "1"}]]}], TraditionalForm]]],
 ", es claro que la suma anterior representa una aproximaci\[OAcute]n del \
\[AAcute]rea de \[CapitalOmega]. Como ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"f", "(", 
        SubscriptBox["\[Theta]", "k"], ")"}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Theta]", "k"], "-", 
       SubscriptBox["\[Theta]", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 " es una suma de Riemann de la funci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Theta]", " ", "\[LongRightArrow]", " ", 
     FractionBox["1", "2"]}], 
    SuperscriptBox[
     RowBox[{"f", "(", "\[Theta]", ")"}], "2"]}], TraditionalForm]]],
 ", se sigue que el \[AAcute]rea de \[CapitalOmega] viene dada por "
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "\[Alpha]", "\[Beta]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"f", "(", "\[Theta]", ")"}], ")"}], "2"], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}], 
  TraditionalForm]], "Text",
 TextAlignment->Center],

Cell["\<\
A este mismo resultadose llega teniendo en cuenta que el \[AAcute]rea de \
\[CapitalOmega] viene dada por\
\>", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{"  ", 
   RowBox[{
    RowBox[{
     FormBox[
      RowBox[{
       RowBox[{"\[Lambda]", "(", "\[CapitalOmega]", ")"}], "=", 
       FractionBox["1", 
        RowBox[{"2", " "}]]}],
      TraditionalForm], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "\[Alpha]", "\[Beta]"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "(", "\[Theta]", ")"}], 
          RowBox[{"y", "'"}], 
          RowBox[{"(", "\[Theta]", ")"}]}], "-", " ", 
         RowBox[{
          RowBox[{"y", "(", "\[Theta]", ")"}], 
          RowBox[{"x", "'"}], 
          RowBox[{"(", "\[Theta]", ")"}]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
    RowBox[{
     RowBox[{"{", GridBox[{
        {
         RowBox[{
          RowBox[{"x", "(", "\[Theta]", ")"}], "=", 
          RowBox[{
           RowBox[{"f", "(", "\[Theta]", ")"}], 
           RowBox[{"cos", "(", "\[Theta]", ")"}]}]}]},
        {
         RowBox[{" ", 
          RowBox[{
           RowBox[{"y", "(", "\[Theta]", ")"}], "=", 
           RowBox[{
            RowBox[{"f", "(", "\[Theta]", ")"}], "sen", " ", 
            RowBox[{"(", "\[Theta]", ")"}]}]}]}]}
       }], "}"}], "=", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "\[Alpha]", "\[Beta]"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"f", "(", "\[Theta]", ")"}], ")"}], "2"], 
        RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}]}]}], 
  TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Con frecuencia, las ecuaciones en coordenadas polares se usan para \
representar distintos tipos de curvas sim\[EAcute]tricas llamadas ",
 StyleBox["\"rosas\"",
  FontSlant->"Italic"],
 ". Por ejemplo, aqu\[IAcute] tienes una rosa de 8 hojas o lazos. "
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolarPlot", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", "\[Theta]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"rosa", " ", "de", " ", "8", " ", "lazos"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.40692156446875*^9, 3.40692156534375*^9}}],

Cell["\<\
La lemniscata es un tipo de rosa de 2 lazos. F\[IAcute]jate que las rosas no \
son curvas simples. Para calcular el \[AAcute]rea de la regi\[OAcute]n del \
plano encerrada por una rosa, es sufieciente, por simetr\[IAcute]a, calcular \
el \[AAcute]rea encerrada por un lazo y multiplicar por el n\[UAcute]mero de \
lazos. \
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle]",
 StyleBox["  El \[AAcute]rea de la regi\[OAcute]n del plano rodeada por un \
lazo de la  lemniscata ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     SuperscriptBox["\[Rho]", "2"], "=", " ", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "\[Theta]"}], ")"}]}]}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox["  ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "4"}], "\[LessEqual]", "t", 
      "\[LessEqual]", 
      RowBox[{"\[Pi]", "/", "4"}]}], ")"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["es igual a ",
  FontWeight->"Plain"]
}], "Text",
 FontWeight->"Bold"],

Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "4"}], 
         RowBox[{"\[Pi]", "/", "4"}]], 
        RowBox[{
         RowBox[{"cos", "(", 
          RowBox[{"2", "\[Theta]"}], ")"}], 
         RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], "="}],
     TraditionalForm], " ", 
    FractionBox["1", "2"]}],
   FontWeight->"Plain"], TextForm]], "Text",
 TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
 "6",
 StyleBox["  Calcular el \[AAcute]rea limitada por el arco de la espiral de \
Arqu\[IAcute]mides ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Rho]", "=", 
     RowBox[{"a", " ", "\[Theta]"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox[" ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"(", 
     RowBox[{"a", ">", "0"}], ")"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["comprendido entre ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Theta]", "=", "0"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[" y ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{"\[Theta]", "=", "\[Pi]"}],
     FontWeight->"Plain"]}], TraditionalForm]]],
 ".",
 StyleBox["\n",
  FontWeight->"Plain"],
 "7",
 StyleBox["  Hallar el \[AAcute]rea encerrada por el lazo interior de la \
curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", " ", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "+", 
     RowBox[{"cos", " ", "\[Theta]"}]}]}], TraditionalForm]],
  FontWeight->"Plain"],
 ".\n8  ",
 StyleBox["Hallar el \[AAcute]rea encerrada por una de las hojas de la rosa ",
  
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Rho]", "=", 
     RowBox[{"2", " ", 
      RowBox[{"cos", "(", 
       RowBox[{"2", "\[Theta]"}], ")"}]}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".\n",
  FontWeight->"Plain"],
 "9 ",
 StyleBox[" Calcular el \[AAcute]rea del l\[OAcute]bulo del folium de \
Descartes de ecuaci\[OAcute]n ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["y", "3"], "-", 
      RowBox[{"3", " ", "a", " ", "x", " ", "y"}]}], "=", "0"}],
    FontWeight->"Plain"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"(", 
     RowBox[{"a", ">", "0"}], ")"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".",
  FontWeight->"Plain"],
 " ",
 StyleBox["Sugerencia: expresar la ecuaci\[OAcute]n en coordenadas polares.\n\
",
  FontWeight->"Plain"],
 "10",
 StyleBox[" Calcular el \[AAcute]rea de la regi\[OAcute]n com\[UAcute]n a las \
dos elipses ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      StyleBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["x", "2"], 
         SuperscriptBox["a", "2"]], "+", 
        FractionBox[
         SuperscriptBox["y", "2"], 
         SuperscriptBox["b", "2"]]}],
       FontSize->18], "=", "1"}], ",", 
     RowBox[{
      StyleBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["x", "2"], 
         SuperscriptBox["b", "2"]], "+", 
        FractionBox[
         SuperscriptBox["y", "2"], 
         SuperscriptBox["a", "2"]]}],
       FontSize->18], "=", "1"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[". Sugerencia: Representar gr\[AAcute]ficamente las elipses. Usar \
la simetr\[IAcute]a polar para simplificar los c\[AAcute]lculos y pasar a \
coordenadas polares.",
  FontWeight->"Plain"]
}], "Text",
 FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Longitud de un arco de curva", "Section"],

Cell[TextData[{
 "Se trata de calcular la longitud de la curva ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " dada por la ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 ", donde suponemos que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", " ", 
    "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
 " es una funci\[OAcute]n con derivada primera continua. Para ello \
aproximamos la curva por poligonales inscritas en ella. Cada \
partici\[OAcute]n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "0"], "<", 
        SubscriptBox["x", "1"], "<", 
        SubscriptBox["x", "2"], "<"}], " ", "..."}], " ", "<", 
      SubscriptBox["x", 
       RowBox[{"n", "-", "1"}]], "<", 
      SubscriptBox["x", "n"]}], "=", "b"}]}], TraditionalForm]]],
 " de",
 StyleBox[" ",
  FontSize->16],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 " induce una poligonal cuyos v\[EAcute]rtices son los puntos ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "k"], ",", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}], ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "k", "\[LessEqual]", " ", "n"}], 
   TraditionalForm]]],
 ". El comando \"arclength[{x[t],y[t]},{t,a,b},n]\" (c\[OAcute]digo original \
de Xah Lee) representa la gr\[AAcute]fica de la curva cuyas ecuaciones param\
\[EAcute]tricas son ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{" ", 
      RowBox[{"{", GridBox[{
         {
          RowBox[{"x", "=", 
           RowBox[{"x", "(", "t", ")"}]}]},
         {
          RowBox[{"y", "=", 
           RowBox[{"y", "(", "t", ")"}]}]}
        }]}]}],
     TraditionalForm]}], TraditionalForm]]],
 " e inscribe en ella una pol\[IAcute]gonal de ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " lados que la divide en ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " partes que tienen la misma longitud. Tambi\[EAcute]n calcula la longitud \
de la poligonal que es una aproximaci\[OAcute]n a la longitud de la curva."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"arclength", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "5"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"una", " ", "par\[AAcute]bola"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.406912718578125*^9, 3.4069127373125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"arclength", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "s", "]"}], ",", 
      RowBox[{"Sin", "[", "s", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "\[Pi]"}], "}"}], ",", "7"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"la", " ", "semicircunferencia", " ", "unidad"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.406921597375*^9, 3.40692159959375*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"arclength", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Theta]"}], "]"}], 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Theta]"}], "]"}], " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", "22", ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"una", " ", "rosa", " ", "de", " ", "cuatro", " ", "hojas"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{3.406921622421875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"arclength", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", "t", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"], "+", "1"}]], ",", 
      FractionBox[
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], " ", 
        RowBox[{"Cos", "[", "t", "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"], "+", "1"}]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", " ", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", "12", ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"417", ",", "147.375"}], "}"}]}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"la", " ", "lemniscata"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.406921618390625*^9, 3.406921618953125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"arclength", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
      RowBox[{"t", " ", 
       RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"6", "\[Pi]"}]}], "}"}], ",", "22", ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"692", ",", "244.5"}], "}"}]}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "3", " ", "vueltas", " ", "de", " ", "la", " ", "espiral", " ", "de", " ", 
    "Arqu\[IAcute]mides"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.4069216430625*^9, 3.40692170765625*^9}}],

Cell[TextData[{
 "La longitud de la poligonal de v\[EAcute]rtices ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "k"], ",", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}], ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "k", "\[LessEqual]", " ", "n"}], 
   TraditionalForm]]],
 ", es igual a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", "k"], "-", 
         SubscriptBox["x", 
          RowBox[{"k", "-", "1"}]]}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "(", 
          SubscriptBox["x", "k"], ")"}], "-", 
         RowBox[{"f", "(", 
          SubscriptBox["x", 
           RowBox[{"k", "-", "1"}]], ")"}]}], ")"}], "2"]}]]}], 
   TraditionalForm]]],
 ". Por el teorema del valor medio, se verifica que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}], "-", 
     RowBox[{"f", "(", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]], ")"}]}], "=", 
    RowBox[{
     RowBox[{"f", " ", "'"}], 
     RowBox[{"(", 
      SubscriptBox["t", "k"], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 " para alg\[UAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "k"], " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]], ",", 
      SubscriptBox["x", "k"]}], "]"}]}], TraditionalForm]]],
 ". Por tanto\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "k"], "-", 
          SubscriptBox["x", 
           RowBox[{"k", "-", "1"}]]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "(", 
           SubscriptBox["x", "k"], ")"}], "-", 
          RowBox[{"f", "(", 
           SubscriptBox["x", 
            RowBox[{"k", "-", "1"}]], ")"}]}], ")"}], "2"]}]]}], "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "n"], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["x", "k"], "-", 
           SubscriptBox["x", 
            RowBox[{"k", "-", "1"}]]}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "'"}], 
           RowBox[{"(", 
            SubscriptBox["t", "k"], ")"}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["x", "k"], "-", 
             SubscriptBox["x", 
              RowBox[{"k", "-", "1"}]]}], ")"}]}], ")"}], "2"]}]]}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "n"], 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "'"}], 
            RowBox[{"(", 
             SubscriptBox["t", "k"], ")"}]}], ")"}], "2"]}]], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", "k"], "-", 
         SubscriptBox["x", 
          RowBox[{"k", "-", "1"}]]}], ")"}]}]}]}]}], TraditionalForm]]],
 "\npero esta es una suma de Riemann de la funci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", " ", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", " ", "'"}], 
        RowBox[{"(", "x", ")"}]}], ")"}], "2"]}]}], TraditionalForm]]],
 ". Deducimos que la longitud de ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " viene dada por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    StyleBox["L",
     FontSize->14], "(", "\[Gamma]", ")"}], "=", 
   RowBox[{
    StyleBox[
     SubsuperscriptBox["\[Integral]", "a", "b"],
     FontSize->14], 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "'"}], 
          RowBox[{"(", "x", ")"}]}], ")"}], "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Para el caso de que la curva ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " venga dada por las ecuaciones param\[EAcute]tricas ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"{", GridBox[{
       {
        RowBox[{"x", "=", 
         RowBox[{"x", "(", "t", ")"}]}]},
       {
        RowBox[{"y", "=", 
         RowBox[{"y", "(", "t", ")"}]}]}
      }]}],
    #& ], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", "\[LessEqual]", " ", "t", "\[LessEqual]", " ", "b"}], ")"}], 
   TraditionalForm]]],
 " donde suponemos que las funciones ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", "\[Rule]", 
     RowBox[{"x", "(", "t", ")"}]}], ",", " ", 
    RowBox[{"t", "\[Rule]", " ", 
     RowBox[{"y", "(", "t", ")"}]}]}], TraditionalForm]]],
 "tienen derivada primera continua, razonando igual que antes se obtiene que \
la longitud de ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " es igual a"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    StyleBox["L",
     FontSize->14], "(", "\[Gamma]", ")"}], "=", 
   RowBox[{
    StyleBox[
     SubsuperscriptBox["\[Integral]", "a", "b"],
     FontSize->14], 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], 
        SuperscriptBox[
         RowBox[{"(", "t", ")"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"y", "'"}], 
        SuperscriptBox[
         RowBox[{"(", "t", ")"}], "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Si la curva ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " viene dada en coordenadas polares por la ecuaci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", 
    RowBox[{"f", "(", "\[Theta]", ")"}]}], TraditionalForm]]],
 ", donde ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ":", 
    RowBox[{
     RowBox[{"[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "\[LongRightArrow]", 
     "\[DoubleStruckCapitalR]"}]}], TraditionalForm]]],
 " es una funci\[OAcute]n con derivada primera continua, entonces la longitud \
de ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " es igual a "
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"L", 
    RowBox[{"(", "\[Gamma]", ")"}]}], "=", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "\[Alpha]", "\[Beta]"], 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"f", 
          RowBox[{"(", "\[Theta]", ")"}]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", " ", "'"}], 
          RowBox[{"(", "\[Theta]", ")"}]}], ")"}], "2"]}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TextForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "F\[OAcute]rmula que puede deducirse de la anterior sin m\[AAcute]s que \
tener en cuenta que las ecuaciones par\[AAcute]metricas de la curva en cuesti\
\[OAcute]n son  ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"{", GridBox[{
       {
        RowBox[{"x", "=", 
         RowBox[{
          RowBox[{"f", "(", "\[Theta]", ")"}], " ", "cos", " ", 
          "\[Theta]"}]}]},
       {
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"f", "(", "\[Theta]", ")"}], " ", "sen", " ", 
          "\[Theta]"}]}]}
      }]}],
    #& ], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
    "\[Alpha]", "\[LessEqual]", " ", "\[Theta]", "\[LessEqual]", " ", 
     "\[Beta]"}], ")"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle] ",
 StyleBox[" La longitud del arco de la cateneria ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"cosh", " ", "x"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 ", ",
 StyleBox["entre",
  FontWeight->"Plain"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]],
  FontWeight->"Plain"],
 " ",
 StyleBox["y",
  FontWeight->"Plain"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" e",
  FontWeight->"Plain"],
 "s ",
 StyleBox["igual a",
  FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"senh", " ", "x"}], ")"}], "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"senh", " ", "x"}], ")"}], "2"]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{"cosh", " ", "x", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
     RowBox[{
      RowBox[{"senh", " ", "1"}], "=", 
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"e", " ", "-", 
         SuperscriptBox["e", 
          RowBox[{"-", "1"}]]}], ")"}]}]}]}]}]}], TextForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "\[FilledSmallCircle] ",
 StyleBox[" La longitud de un arco de la cicloide ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"x", "=", 
      RowBox[{"t", "-", " ", 
       RowBox[{"sen", " ", "t"}]}]}], ",", " ", 
     RowBox[{"y", "=", " ", 
      RowBox[{"1", "-", 
       RowBox[{"cos", " ", "t"}]}]}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["es igual a ",
  FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], 
         SuperscriptBox[
          RowBox[{"(", "t", ")"}], "2"]}], "+", 
        RowBox[{
         RowBox[{"y", "'"}], 
         SuperscriptBox[
          RowBox[{"(", "t", ")"}], "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", 
       RowBox[{"2", "\[Pi]"}]], 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"cos", " ", "t"}]}], ")"}], "2"], "+", 
         RowBox[{
          SuperscriptBox["sen", "2"], "t"}]}]], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], " ", "=", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", "-", 
          RowBox[{"2", "cos", " ", "t"}]}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", 
         RowBox[{"2", "\[Pi]"}]], 
        RowBox[{
         SqrtBox[
          RowBox[{"4", 
           RowBox[{
            SuperscriptBox["sen", "2"], 
            RowBox[{"(", " ", 
             RowBox[{"t", "/", "2"}], ")"}]}]}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Integral]", "0", 
          RowBox[{"2", "\[Pi]"}]], 
         RowBox[{"2", " ", 
          RowBox[{"sen", 
           RowBox[{"(", 
            RowBox[{"t", "/", "2"}], ")"}]}], 
          RowBox[{"\[DifferentialD]", "t"}]}]}], "=", "8"}]}]}]}]}],
   FontWeight->"Plain"], TextForm]], "Text",
 TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
 "11",
 StyleBox["  Calcular la longitud del arco de curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", "4"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[",",
  FontWeight->"Plain"],
 " ",
 StyleBox["entre ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "=", "0"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["y ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "=", "3"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".",
  FontWeight->"Plain"],
 "\n12",
 StyleBox["  Calcular la longitud de la astroide  ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      SuperscriptBox[
       StyleBox[
        RowBox[{"(", 
         FractionBox["x", "a"], ")"}],
        FontSize->18,
        FontWeight->"Plain"], 
       RowBox[{"2", "/", "3"}]], "+", " ", 
      SuperscriptBox[
       StyleBox[
        RowBox[{"(", 
         FractionBox["y", "a"], ")"}],
        FontSize->18,
        FontWeight->"Plain"], 
       RowBox[{"2", "/", "3"}]]}], "=", "1"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[", ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[". Sugerencia: obtener las ecuaciones param\[EAcute]tricas de la \
astroide y tener en cuenta la simetr\[IAcute]a.\n",
  FontWeight->"Plain"],
 "13",
 StyleBox["  Calcular la longitud de la cardioide ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Rho]", "=", 
     RowBox[{"3", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"cos", " ", "\[Theta]"}]}], ")"}]}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[", ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"(", 
     RowBox[{"0", "\[LessEqual]", "\[Theta]", "\[LessEqual]", 
      RowBox[{"2", "\[Pi]"}]}], ")"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".\n",
  FontWeight->"Plain"],
 "14",
 StyleBox[" Calcular la longitud de la curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"y", "=", 
     StyleBox[
      FractionBox[
       RowBox[{" ", 
        RowBox[{
         SuperscriptBox["x", "4"], "+", "48"}]}], 
       RowBox[{"24", "x"}]],
      FontSize->18]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox["donde ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"2", "\[LessEqual]", "x", "\[LessEqual]", "4"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".\n",
  FontWeight->"Plain"],
 "15",
 StyleBox[" Calcular la longitud de la curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"y", "=", 
     RowBox[{"log", "(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["donde ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"1", "/", "3"}], "\[LessEqual]", "x", "\[LessEqual]", 
     RowBox[{"2", "/", "3"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".",
  FontWeight->"Plain"]
}], "Text",
 FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Vol\[UAcute]menes de s\[OAcute]lidos en ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]]
}], "Section"],

Cell[TextData[{
 "Al igual que podemos calcular \[AAcute]reas de regiones planas integrando \
las longitudes de sus secciones por rectas paralelas a una dada, podemos \
tambi\[EAcute]n calcular vol\[UAcute]menes de regiones en ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]],
 "integrando las \[AAcute]reas de sus secciones por planos paralelos a uno \
dado. Este resultado es un caso particular del teorema de Fubini.\n",
 StyleBox["C\[AAcute]lculo de vol\[UAcute]menes por secciones planas. ",
  FontWeight->"Bold"],
 StyleBox["El volumen de una regi\[OAcute]n en ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    StyleBox["3",
     FontWeight->"Bold"]], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox["es igual a la integral del \[AAcute]rea de sus secciones por \
planos paralelos a uno dado.",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\nPara justificar esta afirmaci\[OAcute]n, sea \[CapitalOmega] una regi\
\[OAcute]n en ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]],
 "como la de la figura. "
}], "Text"],

Cell[BoxData["fig2"], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.406912621921875*^9}],

Cell[TextData[{
 "Representemos por ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "(", "x", ")"}], TraditionalForm]]],
 " la secci\[OAcute]n de \[CapitalOmega] por el plano perpendicular al eje OX \
en el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "0", ",", "0"}], ")"}], TraditionalForm]]],
 ". Sea  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", "(", "x", ")"}], TraditionalForm]]],
 " el volumen de la parte de \[CapitalOmega] que queda a la izquierda de \
dicho plano y sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "(", 
    RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}], TraditionalForm]]],
 " el \[AAcute]rea de la secci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "(", "x", ")"}], TraditionalForm]]],
 ". Observa que la situaci\[OAcute]n es totalmente an\[AAcute]loga a la \
considerada en el Teorema Fundamental del C\[AAcute]lculo: all\[IAcute] ten\
\[IAcute]amos la funci\[OAcute]n \[AAcute]rea cuya derivada era la longitud \
de la secci\[OAcute]n. No debe sorprenderte por ello que ahora resulte que la \
derivada de la ",
 StyleBox["funci\[OAcute]n volumen",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", "(", "x", ")"}], TraditionalForm]]],
 ", sea el \[AAcute]rea de la secci\[OAcute]n. En efecto, sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", ">", "0"}], TraditionalForm]]],
 ". Suponiendo, naturalmente, que la funci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}]}], TraditionalForm]]],
 " es continua, tenemos que "
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"min", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Lambda]", "(", 
         RowBox[{"\[CapitalOmega]", "(", "t", ")"}], ")"}], ":", 
        RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
         RowBox[{"x", "+", "h"}]}]}], "}"}], "h"}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"V", "(", 
       RowBox[{"x", "+", "h"}], ")"}], "-", 
      RowBox[{"V", "(", "x", ")"}]}], "\[LessEqual]", 
     RowBox[{"max", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Lambda]", "(", 
         RowBox[{"\[CapitalOmega]", "(", "t", ")"}], ")"}], ":", 
        RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
         RowBox[{"x", "+", "h"}]}]}], "}"}], "h"}]}], ","}], " "}], 
  TraditionalForm]], "Text",
 TextAlignment->Center],

Cell["de donde se deduce que ", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    FormBox[
     SubscriptBox["lim", 
      RowBox[{
       RowBox[{"h", "\[Rule]", "0"}], ",", 
       RowBox[{"h", ">", "0"}]}]],
     TraditionalForm], 
    FormBox[
     RowBox[{
      FractionBox[
       FormBox[
        RowBox[{
         RowBox[{"V", "(", 
          RowBox[{"x", "+", "h"}], ")"}], "-", 
         RowBox[{"V", "(", "x", ")"}]}],
        TraditionalForm], "h"], "=", 
      RowBox[{"\[Lambda]", "(", 
       RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}]}],
     TraditionalForm]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "An\[AAcute]logamente se procede si ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "<", "0"}], TraditionalForm]]],
 ". Hemos obtenido as\[IAcute] que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"V", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}]}], TraditionalForm]]],
 ". Deducimos que el volumen de \[CapitalOmega] viene dado por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{
    RowBox[{"V", "(", "b", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{
      RowBox[{"\[Lambda]", "(", 
       RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Podemos llegar tambi\[EAcute]n a este resultado considerando sumas de \
Riemann. Para ello aproximamos la regi\[OAcute]n \[CapitalOmega] por \
cilindros de la siguiente forma. Consideremos una partici\[OAcute]n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "0"], "<", 
        SubscriptBox["x", "1"], "<", 
        SubscriptBox["x", "2"], "<"}], " ", "..."}], " ", "<", 
      SubscriptBox["x", 
       RowBox[{"n", "-", "1"}]], "<", 
      SubscriptBox["x", "n"]}], "=", "b"}]}], TraditionalForm]]],
 " de",
 StyleBox[" ",
  FontSize->16],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 "; la parte de \[CapitalOmega] comprendida entre los planos perpendiculares \
al eje OX por los puntos ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]], ",", "0", ",", "0"}], ")"}], 
   TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "k"], ",", "0", ",", "0"}], ")"}], TraditionalForm]]],
 " puede aproximarse por un cilindro de altura ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     SubscriptBox["x", "k"],
     TraditionalForm], "-", 
    SubscriptBox["x", 
     RowBox[{"k", "-", "1"}]]}], TraditionalForm]]],
 " y base ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "(", 
    SubscriptBox["x", "k"], ")"}], TraditionalForm]]],
 " cuyo volumen es igual a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"\[CapitalOmega]", "(", 
      SubscriptBox["x", "k"], ")"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["x", "k"], "-", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]]}], ")"}]}], TraditionalForm]]],
 ". Observa la figura (ten paciencia, tarda dos o tres minutos)."
}], "Text",
 CellChangeTimes->{{3.406923584421875*^9, 3.40692359115625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Graphics`SurfaceOfRevolution`"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fig3", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "f", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x_", "]"}], "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"Plus", ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"UnitStep", "[", 
                RowBox[{"x", "-", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", 
                   RowBox[{"1", "/", "5"}]}], ")"}]}], "]"}]}], "+", 
              RowBox[{"UnitStep", "[", 
               RowBox[{"x", "-", "k"}], "]"}]}], ")"}], 
            SqrtBox[
             RowBox[{"1", "-", 
              RowBox[{
               SuperscriptBox["k", "2"], "/", "4"}]}]]}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", 
             RowBox[{"-", "2"}], ",", 
             RowBox[{"2", "+", 
              RowBox[{"1", "/", "5"}]}], ",", 
             RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{"SurfaceOfRevolution", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"RevolutionAxis", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"ViewPoint", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.012"}], ",", " ", 
           RowBox[{"-", "3.277"}], ",", " ", "0.845"}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"510", ",", "283.75"}], "}"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"ExclusionsStyle", "\[Rule]", "Yellow"}], ",", 
        RowBox[{"LightSources", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0", ",", "1", ",", "1"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0", ",", "1", ",", "1"}], "]"}]}], "}"}]}], "}"}]}]}], 
       "]"}]}]}], "]"}]}], ";"}], "\n", "fig3"}], "Input",
 CellChangeTimes->{
  3.406923326546875*^9, {3.40692362459375*^9, 3.4069236495625*^9}, {
   3.406924721984375*^9, 3.406924730703125*^9}}],

Cell[TextData[{
 "La suma de los vol\[UAcute]menes de todos estos cilindros, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{
     RowBox[{"\[Lambda]", "(", 
      RowBox[{"\[CapitalOmega]", "(", 
       SubscriptBox["x", "k"], ")"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 " es por tanto una aproximaci\[OAcute]n del volumen de \[CapitalOmega], pero \
dicha suma es una suma de Riemann de la funci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}]}], TraditionalForm]]],
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", "\[LessEqual]", "x", "\[LessEqual]", "b"}], ")"}], 
   TraditionalForm]]],
 ", por lo que el volumen de \[CapitalOmega] es igual a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{
      RowBox[{"\[Lambda]", "(", 
       RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]]],
 ".\nVamos a estudiar algunos casos en los que es f\[AAcute]cil calcular el \
\[AAcute]rea de las secciones de \[CapitalOmega]."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Volumen de un cuerpo de revoluci\[OAcute]n\
\>", "Subsection"],

Cell[TextData[{
 "Los cuerpos de revoluci\[OAcute]n o s\[OAcute]lidos de revoluci\[OAcute]n \
son regiones de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]],
 "que se obtienen girando una regi\[OAcute]n plana alrededor de una recta \
llamada eje de giro. La orden \"SurfaceOfRevolution[f[x],{x,a,b},opts]\"  \
representa la superficie de revoluci\[OAcute]n obtenida girando la \
gr\[AAcute]fica de f en el plano YZ. Este comando tiene muchas opciones, b\
\[UAcute]scalas en la ayuda de ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Aqu\[IAcute] tienes el s\[OAcute]lido de revoluci\[OAcute]n engendrado al \
girar alrededor del eje OX la gr\[AAcute]fica de la funci\[OAcute]n seno \
entre 0 y \[Pi]."
}], "Text"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"GraphicsArray", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SurfaceOfRevolution", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
        RowBox[{"RevolutionAxis", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"ViewPoint", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.012"}], ",", " ", 
           RowBox[{"-", "3.277"}], ",", " ", "0.845"}], "}"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"1", "/", "2.5"}]}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{".7", "*", 
     RowBox[{"{", 
      RowBox[{"825", ",", "459"}], "}"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.406923609453125*^9, 3.406923615953125*^9}, 
   3.4069237145*^9}],

Cell[CellGroupData[{

Cell["\<\
 M\[EAcute]todo de los discos: secciones perpendiculares al eje de giro\
\>", "Subsubsection"],

Cell[TextData[{
 "Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
    "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
 " una funci\[OAcute]n continua. Girando la regi\[OAcute]n del plano \
comprendida entre la curva ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", " ", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 ", el eje de abscisas y las rectas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "a"}], TraditionalForm]]],
 " e ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "b"}], TraditionalForm]]],
 ",  alrededor del eje OX obtenemos un s\[OAcute]lido de revoluci\[OAcute]n \
",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]]],
 ". Es evidente que la secci\[OAcute]n, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "(", "x", ")"}], TraditionalForm]]],
 ", de ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]]],
 " por el plano perpendicular al eje OX en el punto ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "0", ",", "0"}], ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", "\[LessEqual]", "x", "\[LessEqual]", "b"}], ")"}], 
   TraditionalForm]]],
 ", es un disco contenido en dicho plano de centro",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{"(", 
      RowBox[{"x", ",", "0", ",", "0"}], ")"}],
     TraditionalForm]}], TraditionalForm]]],
 " y radio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "(", "x", ")"}], "|"}], TraditionalForm]]],
 ". Por tanto el \[AAcute]rea de ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "(", "x", ")"}], TraditionalForm]]],
 " es ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"\[CapitalOmega]", "(", "x", ")"}], ")"}], "=", 
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"f", "(", "x", ")"}], "2"]}]}], TraditionalForm]]],
 "; en consecuencia el volumen de \[CapitalOmega] es igual a"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{"\[Pi]", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"f", "(", "x", ")"}], ")"}], "2"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "El volumen del s\[OAcute]lido de revoluci\[OAcute]n, \[CapitalOmega], \
obtenido girando alrededor del eje OX una regi\[OAcute]n de tipo I definida \
por dos funciones continuas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ",", 
    RowBox[{
     RowBox[{"g", ":", 
      RowBox[{"[", 
       RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
     "\[DoubleStruckCapitalR]"}]}], TraditionalForm]]],
 " tales que ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    RowBox[{"f", "(", "x", ")"}], "\[LessEqual]", 
    RowBox[{"g", "(", "x", ")"}]}], TraditionalForm]]],
 " para todo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", 
    RowBox[{"\[Epsilon]", " ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], TraditionalForm]]],
 ", viene dado por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   FormBox[
    RowBox[{
     RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
     RowBox[{"\[Pi]", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "b"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"g", "(", "x", ")"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"f", "(", "x", ")"}], "2"]}], ")"}], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}],
    TraditionalForm]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell["\<\
Una expresi\[OAcute]n similar se obtiene para el volumen de un s\[OAcute]lido \
de revoluci\[OAcute]n obtenido girando alrededor del eje OY una \
regi\[OAcute]n de tipo II.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle]  El volumen de la esfera obtenida girando la \
circunferencia ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", 
    SuperscriptBox["R", "2"]}], TraditionalForm]]],
 " alrededor del eje OX es igual a  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Pi]", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "R"}], "R"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["R", "2"], "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
    FormBox[
     FractionBox[
      RowBox[{"4", " ", "\[Pi]", " ", 
       SuperscriptBox["R", "3"]}], "3"],
     TraditionalForm]}], TraditionalForm]]],
 ".\n\[FilledSmallCircle]  Un cono circular recto de altura ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]]],
 " y radio de la base ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]]],
 " se obtiene girando la recta ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"R", " ", 
     RowBox[{"x", "/", "h"}]}]}], TraditionalForm]]],
 " entre 0 y ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]]],
 ". Su volumen es igual a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Pi]", " ", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "h"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"R", " ", 
          RowBox[{"x", "/", "h"}]}], ")"}], "2"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
    FormBox[
     RowBox[{
      FractionBox["1", "3"], " ", "\[Pi]", " ", 
      SuperscriptBox["R", "2"], "h"}],
     TraditionalForm]}], TraditionalForm]]],
 "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
 "16  ",
 StyleBox["Calcular el  volumen del s\[OAcute]lido engendrado al girar \
alrededor del eje OX la parte de la curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"y", "=", " ", 
     RowBox[{
      SuperscriptBox["sen", "2"], " ", "x"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["comprendida entre ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "=", "0"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["y ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "\[Pi]"}], TraditionalForm]],
  FontWeight->"Plain"],
 ".\n17",
 StyleBox["  Calcular el  volumen del s\[OAcute]lido engendrado al girar \
alrededor del eje OX la gr\[AAcute]fica de la funci\[OAcute]n ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"f", ":"}],
    FontWeight->"Plain"], TraditionalForm]]],
 "[",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"0", ",", 
     RowBox[{"+", "\[Infinity]"}]}],
    FontWeight->"Plain"], TraditionalForm]]],
 "[",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"\[Rule]", "\[DoubleStruckCapitalR]"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["dada por ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], "=", 
     StyleBox[
      FractionBox[
       RowBox[{"18", " ", "x"}], 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "9"}]],
      FontSize->18]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[".",
  FontWeight->"Plain"],
 "\n18",
 StyleBox["  Calcular el volumen del s\[OAcute]lido engendrado al girar la \
regi\[OAcute]n limitada por la par\[AAcute]bola ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", 
    RowBox[{"4", "x"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 " ",
 StyleBox["y la recta ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", " ", "=", "4"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["alrededor de dicha recta.\n",
  FontWeight->"Plain"],
 "19",
 StyleBox["  Calcular el volumen del s\[OAcute]lido engendrado al girar la \
regi\[OAcute]n limitada por las par\[AAcute]bolas ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      StyleBox["y",
       FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], "=", "y"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" alrededor del eje OX.",
  FontWeight->"Plain"],
 "\n20",
 StyleBox["  Calcular el volumen del elipsoide ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     StyleBox[
      RowBox[{
       FractionBox[
        SuperscriptBox["x", "2"], 
        SuperscriptBox["a", "2"]], "+", 
       FractionBox[
        SuperscriptBox["y", "2"], 
        SuperscriptBox["b", "2"]], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], 
        SuperscriptBox["c", "2"]]}],
      FontSize->14], 
     StyleBox["=",
      FontSize->12], 
     StyleBox["1",
      FontSize->12]}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[". ",
  FontWeight->"Plain"],
 "\n21",
 StyleBox[" Calcular el volumen limitado por el paraboloide ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "2"], "9"], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "16"]}], "=", "z"}],
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox[" y el plano ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "7"}], TraditionalForm]],
  FontWeight->"Plain"],
 ". "
}], "Text",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["\<\
 M\[EAcute]todo de las l\[AAcute]minas o de los tubos\
\>", "Subsubsection"],

Cell[TextData[{
 "Consideremos la gr\[AAcute]fica de una funci\[OAcute]n positiva ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LessEqual]", "x", "\[LessEqual]", "b"}], 
   TraditionalForm]]],
 ". Por ejemplo"
}], "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.406923815671875*^9, 3.40692535690625*^9, {3.40692538771875*^9, 
   3.40692549646875*^9}}],

Cell["\<\
Giremos dicha gr\[AAcute]fica alrededor del eje OY.\
\>", "Text"],

Cell[BoxData[
 RowBox[{"SurfaceOfRevolution", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"RevolutionAxis", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4069238273125*^9, 3.406923857234375*^9}}],

Cell["\<\
Obtenemos as\[IAcute] un s\[OAcute]lido de revoluci\[OAcute]n, \
\[CapitalOmega], cuyo volumen podemos aproximar considerando \
rect\[AAcute]ngulos verticales inscritos en la gr\[AAcute]fica y \
gir\[AAcute]ndolos alrededor del eje OY.  \
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "h", "]"}], ";", 
  RowBox[{
   RowBox[{"h", "[", "x_", "]"}], "=", 
   RowBox[{"stepfunc", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", "8"}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"GraphicsArray", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"disco1", "[", 
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1", ",", "9"}], "}"}], ",", 
         RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
       RowBox[{"SurfaceOfRevolution", "[", 
        RowBox[{
         RowBox[{"h", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"RevolutionAxis", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", 
         RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
         RowBox[{"ExclusionsStyle", "\[Rule]", "Yellow"}], ",", 
         RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], "}"}],
      "]"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{".75", "*", 
      RowBox[{"{", 
       RowBox[{"793.563", ",", "377.625"}], "}"}]}]}], ",", 
    RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "h", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.406923919109375*^9, 3.406923927421875*^9}, {
   3.40692465778125*^9, 3.40692466715625*^9}, {3.40692482884375*^9, 
   3.406924886359375*^9}, {3.406924928828125*^9, 3.40692494915625*^9}, {
   3.406924981359375*^9, 3.406925019828125*^9}, {3.406925089734375*^9, 
   3.40692519825*^9}, {3.40692524334375*^9, 3.406925270125*^9}, {
   3.406925306828125*^9, 3.406925314796875*^9}, 3.406925347296875*^9}],

Cell[TextData[{
 "Esto es lo que se conoce como ",
 StyleBox["m\[EAcute]todo de las l\[AAcute]minas o de los tubos",
  FontSlant->"Italic"],
 ". Observa que, a diferencia del m\[EAcute]todo de los discos en el que se \
consideran rect\[AAcute]ngulos perpendiculares al eje de giro, en el m\
\[EAcute]todo de las l\[AAcute]minas o de los tubos los ",
 StyleBox["rect\[AAcute]ngulos considerados son paralelos al eje de giro",
  FontSlant->"Italic"],
 ".\nConsideremos una partici\[OAcute]n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "0"], "<", 
        SubscriptBox["x", "1"], "<", 
        SubscriptBox["x", "2"], "<"}], " ", "..."}], " ", "<", 
      SubscriptBox["x", 
       RowBox[{"n", "-", "1"}]], "<", 
      SubscriptBox["x", "n"]}], "=", "b"}]}], TraditionalForm]]],
 " de",
 StyleBox[" ",
  FontSize->16],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"a", ",", "b"}], "]"}], TraditionalForm]]],
 ". El volumen del s\[OAcute]lido engendrado al girar alrededor del eje OY un \
rect\[AAcute]ngulo vertical cuya base es el intervalo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]], ",", 
     SubscriptBox["x", "k"]}], "]"}], TraditionalForm]]],
 " y altura ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    SubscriptBox["x", "k"], ")"}], TraditionalForm]]],
 " es igual a  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["x", "k", "2"], "-", 
      SubsuperscriptBox["x", 
       RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["x", "k"], ")"}], "=", 
    RowBox[{
     RowBox[{"\[Pi]", "(", 
      RowBox[{
       SubscriptBox["x", "k"], "+", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}], 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 ". La suma de todos ellos es igual a"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{
     RowBox[{"\[Pi]", "(", 
      RowBox[{
       SubscriptBox["x", "k"], "+", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}], 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"\[Pi]", " ", 
      SubscriptBox["x", "k"], 
      RowBox[{"f", "(", 
       SubscriptBox["x", "k"], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "k"], "-", 
        SubscriptBox["x", 
         RowBox[{"k", "-", "1"}]]}], ")"}]}]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"\[Pi]", " ", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]], 
      RowBox[{"f", "(", 
       SubscriptBox["x", "k"], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "k"], "-", 
        SubscriptBox["x", 
         RowBox[{"k", "-", "1"}]]}], ")"}]}]}]}]}], TraditionalForm]], "Text",\

 TextAlignment->Center],

Cell[TextData[{
 "Como las sumas ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{"\[Pi]", " ", 
     SubscriptBox["x", "k"], 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    RowBox[{"\[Pi]", " ", 
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]], 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm]]],
 " son sumas de Riemann de la funci\[OAcute]n ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", " ", 
    RowBox[{"\[Pi]", " ", "x", " ", 
     RowBox[{"f", "(", "x", ")"}]}]}], TraditionalForm]]],
 ", deducimos que el volumen de \[CapitalOmega] viene dado por"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{"2", "\[Pi]", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{"x", " ", 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 " Puedes adaptar f\[AAcute]cilmente esta expresi\[OAcute]n para el caso de \
que el eje de giro sea la recta vertical ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "c"}], TraditionalForm]]],
 ". En general, si notamos por ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "(", "x", ")"}], TraditionalForm]]],
 " el ",
 StyleBox["\"radio de giro\"",
  FontSlant->"Italic"],
 " de la l\[AAcute]mina, entonces"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
   RowBox[{"2", "\[Pi]", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{
      RowBox[{"R", "(", "x", ")"}], " ", 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle]",
 StyleBox["  Consideremos el toro \[DoubleStruckCapitalT] obtenido al girar \
el disco de centro ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", ",", "0"}], ")"}], " "}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[", ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"a", ">", "0"}],
    FontWeight->"Plain"], TraditionalForm]]],
 StyleBox[", y radio ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   StyleBox["R",
    FontWeight->"Plain"], TraditionalForm]]],
 " ",
 StyleBox["alrededor del eje OY. Puedes verlo para ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "2"}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" y ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "1"}], TraditionalForm]],
  FontWeight->"Plain"],
 " ",
 StyleBox["ejecutando la siguiente celda.",
  FontWeight->"Plain"]
}], "Text",
 FontWeight->"Bold"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SurfaceOfRevolution", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "2"}], ")"}], "2"]}]], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", 
       RowBox[{"RevolutionAxis", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
     RowBox[{"SurfaceOfRevolution", "[", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "2"}], ")"}], "2"]}]]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", 
       RowBox[{"RevolutionAxis", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.40692655234375*^9, {3.406926600453125*^9, 3.40692663565625*^9}}],

Cell[TextData[{
 "Por simetr\[IAcute]a, su volumen es el doble del volumen del s\[OAcute]lido \
obtenido al girar la semicircunferencia ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["R", "2"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "2"]}]]}], ",", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "-", "R"}], "\[LessEqual]", "x", "\[LessEqual]", 
      RowBox[{"a", "+", "R"}]}], ")"}]}], TraditionalForm]]],
 " alrededor del eje OY. Por tanto"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Vol", "(", "\[DoubleStruckCapitalT]", ")"}], "=", 
   RowBox[{
    RowBox[{"4", "\[Pi]", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"a", "-", "R"}], 
       RowBox[{"a", "+", "R"}]], 
      RowBox[{"x", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["R", "2"], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "a"}], ")"}], "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
    FormBox[
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["R", 
       RowBox[{"2", " "}]]}],
     TraditionalForm]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["\[FilledSmallCircle]",
  FontWeight->"Bold"],
 StyleBox["  Calcular el volumen del s\[OAcute]lido \[CapitalOmega] \
engendrado al girar la regi\[OAcute]n limitada por las par\[AAcute]bolas ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      StyleBox["y",
       FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], "=", "y"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" alrededor del eje OY.",
  FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox["x"], ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SurfaceOfRevolution", "[", 
      RowBox[{
       SqrtBox["x"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "\[Pi]", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"RevolutionAxis", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"BoundaryStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}], ",", 
     RowBox[{"SurfaceOfRevolution", "[", 
      RowBox[{
       SuperscriptBox["x", "2"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"RevolutionAxis", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"BoundaryStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{".7", "*", 
     RowBox[{"{", 
      RowBox[{"793.563", ",", "377.625"}], "}"}]}]}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.012"}], ",", " ", 
      RowBox[{"-", "3.382"}], ",", " ", "0.109"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.406926683140625*^9, 3.40692669309375*^9}, {
  3.406926790578125*^9, 3.40692684215625*^9}, {3.406926899734375*^9, 
  3.406926908140625*^9}}],

Cell[TextData[{
 "El s\[OAcute]lido de revoluci\[OAcute]n engendrado es una especie de embudo \
acotado por dos superficies de revoluci\[OAcute]n, la superior obtenida al \
girar la gr\[AAcute]fica ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SqrtBox["x"]}], TraditionalForm]]],
 "y la inferior obtenida al girar ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]]],
 ". El volumen pedido viene, por tanto, dado por  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Vol", "(", "\[CapitalOmega]", ")"}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", "1"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", 
           SqrtBox["x"]}], "-", 
          SuperscriptBox["x", "3"]}], ")"}], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
     FormBox[
      FractionBox[
       RowBox[{"3", " ", "\[Pi]"}], "10"],
      TraditionalForm]}]}], TraditionalForm]]],
 "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
 StyleBox["22",
  FontWeight->"Bold"],
 "  ",
 StyleBox["Calcular el  volumen del toro engendrado al girar el \
c\[IAcute]rculo de centro 0 y radio 3 alrededor de la recta ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "6"}], TraditionalForm]]],
 ".\n",
 StyleBox["23",
  FontWeight->"Bold"],
 StyleBox["  Calcular el volumen del s\[OAcute]lido \[CapitalOmega] \
engendrado al girar la regi\[OAcute]n limitada por las par\[AAcute]bolas ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      StyleBox["y",
       FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], "=", "y"}]}], TraditionalForm]],
  FontWeight->"Plain"],
 StyleBox[" alrededor de la recta ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "4"}], TraditionalForm]]],
 "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalAAcute]rea de una superficie de revoluci\[OAcute]n\
\>", "Section"],

Cell[TextData[{
 "Una superficie de revoluci\[OAcute]n se obtiene girando una curva dada \
alrededor de una recta. Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", ":", 
     RowBox[{"[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "\[Rule]", 
    "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
 " una funci\[OAcute]n con derivada primera continua. Girando la \
gr\[AAcute]fica de dicha funci\[OAcute]n alrededor del eje OX obtenemos una \
superficie de revoluci\[OAcute]n, \[CapitalGamma]. F\[IAcute]jate en la \
siguiente representaci\[OAcute]n."
}], "Text"],

Cell[BoxData["fig4"], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.406912223859375*^9}],

Cell[TextData[{
 "Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "(", "x", ")"}], TraditionalForm]]],
 " el \[AAcute]rea de la parte de la superficie comprendida entre los planos \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "=", "a"}], TraditionalForm]]],
 ", y ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "=", "x"}], TraditionalForm]]],
 ". Representemos por ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "(", "x", ")"}], TraditionalForm]]],
 " la longitud de la gr\[AAcute]fica de ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " entre ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ". Recuerda que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"L", "(", "x", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "x"], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"f", "'"}], 
         SuperscriptBox[
          RowBox[{"(", "t", ")"}], "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]]],
 ". Teniendo en cuenta que el \[AAcute]rea lateral de un cilindro circular \
recto es igual a la longitud de la base por la altura, se deduce que"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "min"}], TraditionalForm]]],
 "{",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], ":", 
    RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"x", "+", "h"}]}]}], TraditionalForm]]],
 "}",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"L", "(", 
       RowBox[{"x", "+", "h"}], ")"}], "-", 
      RowBox[{"L", "(", "x", ")"}]}], ")"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"S", "(", 
      RowBox[{"x", "+", "h"}], ")"}], "-", 
     RowBox[{"S", "(", "x", ")"}]}], "\[LessEqual]", 
    RowBox[{"2", "\[Pi]", " ", "max"}]}], TraditionalForm]]],
 "{",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], ":", 
    RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"x", "+", "h"}]}]}], TraditionalForm]]],
 "}",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"L", "(", 
      RowBox[{"x", "+", "h"}], ")"}], "-", 
     RowBox[{"L", "(", "x", ")"}]}], ")"}], TraditionalForm]]]
}], "Text",
 TextAlignment->Center],

Cell["Por tanto ", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{"2", "\[Pi]", " ", "min", 
   RowBox[{"{", 
    FormBox[
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], ":", 
      RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
       RowBox[{"x", "+", "h"}]}]}],
     TraditionalForm], "}"}], 
   FormBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"L", "(", 
        RowBox[{"x", "+", "h"}], ")"}], "-", 
       RowBox[{"L", "(", "x", ")"}]}], "h"], "\[LessEqual]", 
     FractionBox[
      RowBox[{
       RowBox[{"S", "(", 
        RowBox[{"x", "+", "h"}], ")"}], "-", 
       RowBox[{"S", "(", "x", ")"}]}], "h"], "\[LessEqual]", 
     RowBox[{"2", "\[Pi]", " ", "max"}]}],
    TraditionalForm], 
   RowBox[{"{", 
    FormBox[
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], ":", 
      RowBox[{"x", "\[LessEqual]", "t", "\[LessEqual]", 
       RowBox[{"x", "+", "h"}]}]}],
     TraditionalForm], "}"}], 
   FormBox[
    FractionBox[
     RowBox[{
      RowBox[{"L", "(", 
       RowBox[{"x", "+", "h"}], ")"}], "-", 
      RowBox[{"L", "(", "x", ")"}]}], "h"],
    TraditionalForm]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Tomando l\[IAcute]mites para ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "\[Rule]", "0"}], TraditionalForm]]],
 " deducimos que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"S", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", 
      RowBox[{"f", "(", "x", ")"}], " ", 
      RowBox[{"L", "'"}], 
      RowBox[{"(", "x", ")"}]}], "=", 
     RowBox[{"2", "\[Pi]", " ", 
      RowBox[{"f", "(", "x", ")"}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"f", "'"}], 
         SuperscriptBox[
          RowBox[{"(", "x", ")"}], "2"]}]}]]}]}]}], TraditionalForm]]],
 ". Luego el \[AAcute]rea de la superficie  \[CapitalGamma] viene dada por "
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Lambda]", "(", "\[CapitalGamma]", ")"}], "=", 
   RowBox[{"2", "\[Pi]", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "b"], 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"f", "'"}], 
         SuperscriptBox[
          RowBox[{"(", "x", ")"}], "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], "Text",
 TextAlignment->Center],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
 "\[FilledSmallCircle]  El \[AAcute]rea de una superficie esf\[EAcute]rica de \
radio ",
 StyleBox["R",
  FontSlant->"Italic"],
 " viene dada por ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "R"}], "R"], 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["R", "2"], "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           StyleBox[
            FractionBox[
             RowBox[{"-", "x"}], 
             SqrtBox[
              RowBox[{
               SuperscriptBox["R", "2"], "-", 
               SuperscriptBox["x", "2"]}]]],
            FontSize->18], 
           StyleBox[")",
            FontSize->18]}], "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
    FormBox[
     RowBox[{"4", " ", "\[Pi]", " ", 
      SuperscriptBox["R", "2"]}],
     TraditionalForm]}], TraditionalForm]]],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
 StyleBox["24",
  FontWeight->"Bold"],
 "  ",
 StyleBox["Calcular el  \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox["x", "3"]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "1"}], 
   TraditionalForm]]],
 ", alrededor del eje OX.\n",
 StyleBox["25",
  FontWeight->"Bold"],
 StyleBox["  Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la curva ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"2", "/", "3"}]], "+", 
      SuperscriptBox["y", 
       RowBox[{"2", "/", "3"}]]}], "=", 
     SuperscriptBox["a", 
      RowBox[{"2", "/", "3"}]]}], ","}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}], TraditionalForm]]],
 ", alrededor del eje OX.\n",
 StyleBox["26  ",
  FontWeight->"Bold"],
 StyleBox["Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la elipse ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "2"], "4"], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "9"]}],
     FontSize->18], "=", "1"}], TraditionalForm]]],
 " alrededor del eje OY.\n",
 StyleBox["27  ",
  FontWeight->"Bold"],
 StyleBox["Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la catenaria ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"cosh", " ", "x"}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "1"}], TraditionalForm]]]
 ,
 ", alrededor del eje OX.\n",
 StyleBox["28  ",
  FontWeight->"Bold"],
 "Al girar alrededor del eje OX el segmento de par\[AAcute]bola ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SqrtBox["x"]}], TraditionalForm]]],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "a"}], 
   TraditionalForm]]],
 ", engendra un tronco de paraboloide de revoluci\[OAcute]n cuya superficie \
tiene \[AAcute]rea igual a la de una esfera de radio ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"13", "/", "12"}]], TraditionalForm]]],
 ". Se pide calcular el valor de ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ".\n",
 StyleBox["29 ",
  FontWeight->"Bold"],
 "Comprueba que el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
(llamada ",
 StyleBox["horno de Gabriel",
  FontSlant->"Italic"],
 ") engendrada al girar la curva ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"1", "/", "x"}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "x", "<", 
    RowBox[{"+", "\[Infinity]"}]}], TraditionalForm]]],
 ", alrededor del eje OX es infinita (por tanto ser\[IAcute]a necesaria una \
cantidad infinita de pintura si quisi\[EAcute]ramos pintarla) pero el volumen \
del s\[OAcute]lido de revoluci\[OAcute]n engendrado es finito (por tanto \
podemos llenarlo con una cantidad finita de pintura). Comenta a tu gusto esta \
aparente paradoja.\n",
 StyleBox["30",
  FontWeight->"Bold"],
 " Calcular el \[AAcute]rea de un espejo parab\[OAcute]lico de 3 metros de di\
\[AAcute]metro y 1 metro de fondo."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
PageHeaders->{{Inherited, Inherited, Inherited}, {
   Cell[
    TextData["Aplicaciones de las integrales"], "Header"], 
   Cell[
    TextData["Prof. Javier P\[EAcute]rez"], "Header"], Inherited}},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (June 19, 2007)",
StyleDefinitions->"Classroom.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 55, 0, 69, "Title"],
Cell[626, 23, 240, 10, 105, "Text",
 PageBreakBelow->False],
Cell[CellGroupData[{
Cell[891, 37, 39, 0, 67, "Section"],
Cell[933, 39, 633, 11, 104, "Text"],
Cell[1569, 52, 454, 9, 193, "Text"],
Cell[2026, 63, 251, 5, 29, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2314, 73, 41, 0, 67, "Section"],
Cell[2358, 75, 2154, 60, 146, "Input",
 InitializationCell->True],
Cell[4515, 137, 9937, 242, 711, "Input",
 InitializationCell->True],
Cell[14455, 381, 10282, 253, 770, "Input",
 InitializationCell->True],
Cell[24740, 636, 3595, 92, 253, "Input",
 InitializationCell->True],
Cell[28338, 730, 10303, 256, 797, "Input",
 InitializationCell->True],
Cell[38644, 988, 9868, 245, 812, "Input",
 InitializationCell->True],
Cell[48515, 1235, 3964, 112, 234, "Input",
 InitializationCell->True],
Cell[52482, 1349, 6466, 171, 341, "Input",
 InitializationCell->True],
Cell[58951, 1522, 10108, 273, 695, "Input",
 InitializationCell->True],
Cell[69062, 1797, 9864, 248, 407, "Input",
 InitializationCell->True],
Cell[78929, 2047, 7921, 230, 344, "Input",
 InitializationCell->True],
Cell[86853, 2279, 2843, 77, 264, "Input",
 InitializationCell->True],
Cell[89699, 2358, 1154, 36, 102, "Input",
 InitializationCell->True],
Cell[90856, 2396, 3763, 105, 256, "Input",
 InitializationCell->True],
Cell[94622, 2503, 9289, 254, 410, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[103948, 2762, 58, 0, 67, "Section"],
Cell[104009, 2764, 3774, 131, 207, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107820, 2900, 57, 0, 67, "Section"],
Cell[CellGroupData[{
Cell[107902, 2904, 106, 5, 48, "Subsubsection"],
Cell[108011, 2911, 1236, 42, 73, "Text"],
Cell[109250, 2955, 367, 11, 57, "Input"],
Cell[109620, 2968, 704, 23, 61, "Input"],
Cell[110327, 2993, 786, 24, 80, "Input"],
Cell[111116, 3019, 333, 10, 29, "Text"],
Cell[111452, 3031, 371, 11, 50, "Text"],
Cell[111826, 3044, 1894, 58, 114, "Text"],
Cell[113723, 3104, 403, 12, 57, "Input"],
Cell[114129, 3118, 404, 12, 57, "Input"],
Cell[114536, 3132, 183, 4, 29, "Text"],
Cell[114722, 3138, 579, 16, 57, "Input"],
Cell[115304, 3156, 570, 16, 57, "Input"],
Cell[115877, 3174, 1265, 43, 71, "Text"],
Cell[117145, 3219, 1396, 42, 130, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118578, 3266, 36, 0, 44, "Subsubsection"],
Cell[118617, 3268, 448, 17, 31, "Text"],
Cell[119068, 3287, 94, 2, 29, "Text"],
Cell[119165, 3291, 375, 13, 61, "Input"],
Cell[119543, 3306, 121, 3, 29, "Text"],
Cell[119667, 3311, 1037, 33, 107, "Input"],
Cell[120707, 3346, 473, 15, 36, "Text"],
Cell[121183, 3363, 395, 13, 80, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121615, 3381, 36, 0, 44, "Subsubsection"],
Cell[121654, 3383, 355, 13, 31, "Text"],
Cell[122012, 3398, 368, 15, 31, "Text"],
Cell[122383, 3415, 220, 7, 61, "Input"],
Cell[122606, 3424, 689, 23, 87, "Input"],
Cell[123298, 3449, 709, 25, 54, "Text"],
Cell[124010, 3476, 2595, 77, 156, "Input"],
Cell[126608, 3555, 978, 34, 37, "Text"],
Cell[127589, 3591, 489, 18, 63, "Input"],
Cell[128081, 3611, 1118, 45, 54, "Text"],
Cell[129202, 3658, 1036, 36, 174, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130275, 3699, 46, 0, 44, "Subsubsection"],
Cell[130324, 3701, 1371, 38, 92, "Text"],
Cell[131698, 3741, 465, 13, 76, "Input"],
Cell[132166, 3756, 405, 13, 80, "Input"],
Cell[132574, 3771, 436, 15, 30, "Text"],
Cell[133013, 3788, 371, 11, 50, "Text"],
Cell[133387, 3801, 1993, 62, 115, "Text"],
Cell[135383, 3865, 403, 12, 76, "Input"],
Cell[135789, 3879, 404, 12, 76, "Input"],
Cell[136196, 3893, 183, 4, 29, "Text"],
Cell[136382, 3899, 628, 17, 76, "Input"],
Cell[137013, 3918, 574, 16, 76, "Input"],
Cell[137590, 3936, 4189, 106, 413, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141816, 4047, 36, 0, 44, "Subsubsection"],
Cell[141855, 4049, 1236, 38, 108, "Text"],
Cell[143094, 4089, 327, 10, 80, "Input"],
Cell[143424, 4101, 464, 15, 35, "Text"],
Cell[143891, 4118, 225, 7, 61, "Input"],
Cell[144119, 4127, 199, 4, 29, "Text"],
Cell[144321, 4133, 325, 10, 80, "Input"],
Cell[144649, 4145, 356, 9, 50, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145042, 4159, 32, 0, 54, "Subsection"],
Cell[145077, 4161, 5367, 235, 457, "Text"],
Cell[150447, 4398, 347, 13, 40, "Text"],
Cell[150797, 4413, 789, 26, 131, "Input"],
Cell[151589, 4441, 472, 18, 46, "Text"],
Cell[152064, 4461, 679, 21, 131, "Input"],
Cell[152746, 4484, 430, 16, 31, "Text"],
Cell[153179, 4502, 792, 26, 152, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154020, 4534, 79, 2, 67, "Section"],
Cell[154102, 4538, 6281, 179, 399, "Text"],
Cell[CellGroupData[{
Cell[160408, 4721, 34, 0, 44, "Subsubsection"],
Cell[160445, 4723, 1114, 39, 51, "Text"],
Cell[161562, 4764, 427, 14, 76, "Input"],
Cell[161992, 4780, 923, 32, 51, "Text"],
Cell[162918, 4814, 684, 21, 99, "Input"],
Cell[163605, 4837, 94, 2, 29, "Text"],
Cell[163702, 4841, 97, 1, 76, "Input"],
Cell[163802, 4844, 897, 29, 51, "Text"],
Cell[164702, 4875, 624, 19, 76, "Input"],
Cell[165329, 4896, 734, 24, 56, "Text"],
Cell[166066, 4922, 76, 1, 76, "Input"],
Cell[166145, 4925, 2028, 71, 53, "Text"],
Cell[168176, 4998, 927, 27, 129, "Input"],
Cell[169106, 5027, 655, 17, 77, "Text"],
Cell[169764, 5046, 112, 3, 29, "Text"],
Cell[169879, 5051, 648, 19, 99, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170564, 5075, 216, 6, 48, "Subsubsection"],
Cell[170783, 5083, 1541, 50, 73, "Text"],
Cell[172327, 5135, 1646, 57, 63, "Text"],
Cell[173976, 5194, 728, 19, 71, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174741, 5218, 34, 0, 44, "Subsubsection"],
Cell[174778, 5220, 1614, 62, 29, "Text"],
Cell[176395, 5284, 157, 3, 29, "Text"],
Cell[176555, 5289, 617, 21, 121, "Input"],
Cell[177175, 5312, 1911, 69, 52, "Text"],
Cell[179089, 5383, 190, 3, 29, "Text"],
Cell[179282, 5388, 1240, 45, 165, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180559, 5438, 34, 0, 54, "Subsection"],
Cell[180596, 5440, 1200, 47, 30, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[181845, 5493, 78, 2, 67, "Section"],
Cell[181926, 5497, 4493, 173, 178, "Text"],
Cell[186422, 5672, 719, 24, 95, "Input"],
Cell[187144, 5698, 2614, 81, 167, "Text"],
Cell[189761, 5781, 1027, 30, 100, "Input"],
Cell[190791, 5813, 1184, 37, 86, "Input"],
Cell[191978, 5852, 668, 15, 121, "Input"],
Cell[192649, 5869, 1419, 40, 71, "Text"],
Cell[194071, 5911, 96, 2, 76, "Input",
 InitializationCell->True],
Cell[194170, 5915, 3377, 112, 148, "Text"],
Cell[197550, 6029, 437, 14, 50, "Text"],
Cell[197990, 6045, 129, 3, 29, "Text"],
Cell[198122, 6050, 1599, 51, 50, "Text"],
Cell[199724, 6103, 282, 6, 50, "Text"],
Cell[200009, 6111, 476, 13, 76, "Input"],
Cell[200488, 6126, 345, 6, 50, "Text"],
Cell[CellGroupData[{
Cell[200858, 6136, 33, 0, 44, "Subsubsection"],
Cell[200894, 6138, 774, 29, 31, "Text"],
Cell[201671, 6169, 566, 20, 52, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202274, 6194, 34, 0, 54, "Subsection"],
Cell[202311, 6196, 3278, 124, 192, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[205638, 6326, 47, 0, 67, "Section"],
Cell[205688, 6328, 2372, 78, 135, "Text"],
Cell[208063, 6408, 421, 12, 80, "Input"],
Cell[208487, 6422, 461, 13, 76, "Input"],
Cell[208951, 6437, 749, 21, 99, "Input"],
Cell[209703, 6460, 937, 27, 152, "Input"],
Cell[210643, 6489, 762, 21, 80, "Input"],
Cell[211408, 6512, 4072, 143, 134, "Text"],
Cell[215483, 6657, 507, 19, 58, "Text"],
Cell[215993, 6678, 1005, 36, 68, "Text"],
Cell[217001, 6716, 581, 22, 58, "Text"],
Cell[217585, 6740, 662, 22, 50, "Text"],
Cell[218250, 6764, 599, 20, 50, "Text"],
Cell[218852, 6786, 781, 28, 68, "Text"],
Cell[CellGroupData[{
Cell[219658, 6818, 34, 0, 44, "Subsubsection"],
Cell[219695, 6820, 646, 30, 29, "Text"],
Cell[220344, 6852, 1019, 35, 50, "Text"],
Cell[221366, 6889, 479, 18, 29, "Text"],
Cell[221848, 6909, 1907, 64, 50, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223792, 6978, 32, 0, 54, "Subsection"],
Cell[223827, 6980, 3359, 134, 201, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[227235, 7120, 171, 5, 67, "Section"],
Cell[227409, 7127, 1203, 30, 140, "Text"],
Cell[228615, 7159, 99, 2, 76, "Input",
 InitializationCell->True],
Cell[228717, 7163, 1664, 47, 92, "Text"],
Cell[230384, 7212, 823, 24, 29, "Text"],
Cell[231210, 7238, 39, 0, 29, "Text"],
Cell[231252, 7240, 613, 22, 49, "Text"],
Cell[231868, 7264, 467, 15, 29, "Text"],
Cell[232338, 7281, 410, 12, 50, "Text"],
Cell[232751, 7295, 2008, 67, 97, "Text"],
Cell[234762, 7364, 91, 2, 57, "Input"],
Cell[234856, 7368, 3087, 81, 277, "Input"],
Cell[237946, 7451, 1456, 42, 91, "Text"],
Cell[CellGroupData[{
Cell[239427, 7497, 72, 2, 54, "Subsection"],
Cell[239502, 7501, 774, 16, 94, "Text"],
Cell[240279, 7519, 1519, 37, 168, "Input"],
Cell[CellGroupData[{
Cell[241823, 7560, 104, 2, 44, "Subsubsection"],
Cell[241930, 7564, 2071, 72, 94, "Text"],
Cell[244004, 7638, 382, 12, 50, "Text"],
Cell[244389, 7652, 786, 25, 50, "Text"],
Cell[245178, 7679, 555, 18, 50, "Text"],
Cell[245736, 7699, 196, 4, 29, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[245969, 7708, 34, 0, 44, "Subsubsection"],
Cell[246006, 7710, 1760, 63, 111, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[247815, 7779, 34, 0, 54, "Subsection"],
Cell[247852, 7781, 3824, 151, 219, "Text"],
Cell[CellGroupData[{
Cell[251701, 7936, 86, 2, 44, "Subsubsection"],
Cell[251790, 7940, 333, 12, 29, "Text"],
Cell[252126, 7954, 303, 9, 61, "Input"],
Cell[252432, 7965, 75, 2, 29, "Text"],
Cell[252510, 7969, 487, 12, 85, "Input"],
Cell[253000, 7983, 261, 5, 50, "Text"],
Cell[253264, 7990, 2013, 49, 177, "Input"],
Cell[255280, 8041, 2228, 72, 110, "Text"],
Cell[257511, 8115, 1311, 46, 60, "Text"],
Cell[258825, 8163, 1134, 39, 52, "Text"],
Cell[259962, 8204, 339, 10, 50, "Text"],
Cell[260304, 8216, 435, 14, 50, "Text"],
Cell[260742, 8232, 371, 11, 50, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[261150, 8248, 34, 0, 44, "Subsubsection"],
Cell[261187, 8250, 1042, 42, 51, "Text"],
Cell[262232, 8294, 1640, 43, 205, "Input"],
Cell[263875, 8339, 586, 18, 61, "Text"],
Cell[264464, 8359, 731, 24, 50, "Text"],
Cell[265198, 8385, 564, 18, 31, "Text"],
Cell[265765, 8405, 255, 9, 63, "Input"],
Cell[266023, 8416, 2061, 51, 179, "Input"],
Cell[268087, 8469, 1035, 34, 64, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269171, 8509, 34, 0, 54, "Subsection"],
Cell[269208, 8511, 908, 32, 64, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[270165, 8549, 86, 2, 67, "Section"],
Cell[270254, 8553, 572, 14, 50, "Text"],
Cell[270829, 8569, 99, 2, 57, "Input",
 InitializationCell->True],
Cell[270931, 8573, 1220, 44, 84, "Text"],
Cell[272154, 8619, 1120, 41, 29, "Text"],
Cell[273277, 8662, 26, 0, 29, "Text"],
Cell[273306, 8664, 1137, 38, 49, "Text"],
Cell[274446, 8704, 762, 26, 40, "Text"],
Cell[275211, 8732, 495, 16, 50, "Text"],
Cell[CellGroupData[{
Cell[275731, 8752, 34, 0, 44, "Subsubsection"],
Cell[275768, 8754, 1047, 38, 58, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276852, 8797, 34, 0, 54, "Subsection"],
Cell[276889, 8799, 3488, 117, 305, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
